/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.model.util;

import io.vrap.rmf.nodes.Node;
import io.vrap.rmf.nodes.NodeModelBuilder;
import io.vrap.rmf.nodes.antlr.NodeToken;
import io.vrap.rmf.nodes.antlr.NodeTokenProvider;
import io.vrap.rmf.raml.model.RamlDiagnostic;
import io.vrap.rmf.raml.model.RamlModelResult;
import io.vrap.rmf.raml.model.types.AnyType;
import io.vrap.rmf.raml.model.types.Instance;
import io.vrap.rmf.raml.model.util.NodeToInstanceTransformation;
import io.vrap.rmf.raml.validation.InstanceValidator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public interface InstanceHelper {
    public static RamlModelResult<Instance> parseAndValidate(String text, AnyType type) {
        Instance instance = InstanceHelper.parse(text, InstanceHelper.resourceFile(type));
        List<Resource.Diagnostic> validationResults = InstanceHelper.validate(instance, type).stream().map(RamlDiagnostic::of).collect(Collectors.toList());
        return RamlModelResult.of(validationResults, instance);
    }

    public static Instance parse(String text) {
        return InstanceHelper.parse(text, null);
    }

    public static Instance parse(String text, String resource) {
        NodeModelBuilder nodeModelBuilder = new NodeModelBuilder();
        Node node = resource == null ? nodeModelBuilder.parseYaml(text) : nodeModelBuilder.parseJson(text);
        return (Instance)new NodeToInstanceTransformation().doSwitch((EObject)node);
    }

    public static Instance parseJson(String text) {
        return InstanceHelper.parseJson(text, null);
    }

    public static Instance parseJson(String text, String resource) {
        NodeModelBuilder nodeModelBuilder = new NodeModelBuilder();
        Node node = nodeModelBuilder.parseJson(text);
        return (Instance)new NodeToInstanceTransformation().doSwitch((EObject)node);
    }

    public static List<Diagnostic> validate(Instance instance, AnyType type) {
        return new InstanceValidator().validate(instance, type);
    }

    public static String resourceFile(EObject object) {
        String source = null;
        NodeTokenProvider ramlTokenProvider = (NodeTokenProvider)EcoreUtil.getExistingAdapter((Notifier)object, NodeTokenProvider.class);
        if (ramlTokenProvider != null) {
            NodeToken nodeToken = ramlTokenProvider.getStart();
            source = nodeToken.getLocation();
        }
        return source;
    }
}

