/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.model.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public enum StringCaseFormat implements Predicate<String>,
Function<String, String>
{
    LOWER_CAMEL_CASE(s -> s.matches("\\p{Lower}(\\p{Lower}|\\p{Upper})*"), StringCaseFormat::split, StringCaseFormat::lcFirst, StringCaseFormat::ucFirst),
    UPPER_CAMEL_CASE(s -> s.matches("\\p{Upper}(\\p{Lower}|\\p{Upper})*"), StringCaseFormat::split, StringCaseFormat::ucFirst, StringCaseFormat::ucFirst),
    LOWER_HYPHEN_CASE(s -> s.matches("\\p{Lower}(-|\\p{Lower})+"), StringCaseFormat::split, "-", String::toLowerCase),
    UPPER_HYPHEN_CASE(s -> s.matches("\\p{Upper}(-|\\p{Upper})+"), StringCaseFormat::split, "-", String::toUpperCase),
    LOWER_UNDERSCORE_CASE(s -> s.matches("\\p{Lower}(_|\\p{Lower})+"), StringCaseFormat::split, "_", String::toLowerCase),
    UPPER_UNDERSCORE_CASE(s -> s.matches("\\p{Upper}(_|\\p{Upper})+"), StringCaseFormat::split, "_", String::toUpperCase);

    private final Predicate<String> test;
    private final Function<String, List<String>> wordSeparator;
    private final String delimiter;
    private final Function<String, String> firstWordTransform;
    private final Function<String, String> otherWordTransform;

    private StringCaseFormat(Predicate<String> test, Function<String, List<String>> wordSeparator, String delimiter, Function<String, String> firstWordTransform, Function<String, String> otherWordTransform) {
        this.test = test;
        this.wordSeparator = wordSeparator;
        this.delimiter = delimiter;
        this.firstWordTransform = firstWordTransform;
        this.otherWordTransform = otherWordTransform;
    }

    private StringCaseFormat(Predicate<String> test, Function<String, List<String>> wordSeparator, String delimiter, Function<String, String> wordTransform) {
        this(test, wordSeparator, delimiter, wordTransform, wordTransform);
    }

    private StringCaseFormat(Predicate<String> test, Function<String, List<String>> wordSeparator, Function<String, String> firstWordTransform, Function<String, String> otherWordTransform) {
        this(test, wordSeparator, "", firstWordTransform, otherWordTransform);
    }

    @Override
    public boolean test(String value) {
        return this.test.test(value);
    }

    @Override
    public String apply(String value) {
        Optional<StringCaseFormat> sourceFormat = Stream.of(StringCaseFormat.values()).filter(stringCaseFormat -> stringCaseFormat.test(value)).findFirst();
        return sourceFormat.map(source -> this.render(source.compoundWords(value))).orElse(this.render(this.compoundWords(value)));
    }

    static List<String> split(String value) {
        return Arrays.asList(value.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])|[-_]"));
    }

    @VisibleForTesting
    String render(List<String> compoundWords) {
        StringBuffer buffer = new StringBuffer();
        Function<String, String> transform = this.firstWordTransform;
        String separator = "";
        for (String word : compoundWords) {
            if (word.equals("")) continue;
            buffer.append(separator).append(transform.apply(word));
            separator = this.delimiter;
            transform = this.otherWordTransform;
        }
        return buffer.toString();
    }

    @VisibleForTesting
    List<String> compoundWords(String value) {
        return this.wordSeparator.apply(value);
    }

    private static final String lcFirst(String value) {
        return value.isEmpty() ? "" : Character.toLowerCase(value.charAt(0)) + (value.length() == 1 ? "" : value.substring(1).toLowerCase());
    }

    private static final String ucFirst(String value) {
        return value.isEmpty() ? "" : Character.toUpperCase(value.charAt(0)) + (value.length() == 1 ? "" : value.substring(1).toLowerCase());
    }
}

