/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.model.util;

import io.vrap.functional.utils.TypeSwitch;
import io.vrap.rmf.raml.model.elements.NamedElement;
import io.vrap.rmf.raml.model.resources.Method;
import io.vrap.rmf.raml.model.resources.Resource;
import io.vrap.rmf.raml.model.responses.Body;
import io.vrap.rmf.raml.model.responses.Response;
import io.vrap.rmf.raml.model.types.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;

public class UriFragmentBuilder {
    private static final Collector<CharSequence, ?, String> SEGMENT_JOINER = Collectors.joining("/", "/", "");
    private final TypeSwitch<EObject, List<String>> uriFragmentsBuilderSwitch = new TypeSwitch().on(Body.class, this::body).on(NamedElement.class, this::namedElement).on(Annotation.class, this::annotation).on(Method.class, this::method).on(Resource.class, this::resource).on(Response.class, this::response).fallthrough(this::defaultCase);

    public String getURIFragment(EObject eObject) {
        return ((List)this.uriFragmentsBuilderSwitch.apply((Object)eObject)).stream().collect(SEGMENT_JOINER);
    }

    private List<String> namedElement(NamedElement identifiableElement) {
        List<String> segments = identifiableElement.eContainer() != null ? (List)this.uriFragmentsBuilderSwitch.apply((Object)identifiableElement.eContainer()) : new ArrayList<String>();
        segments.add(identifiableElement.eContainmentFeature().getName());
        segments.add(identifiableElement.getName());
        return segments;
    }

    private List<String> annotation(Annotation annotation) {
        if (annotation.eContainer() != null && annotation.getType() != null) {
            List segments = (List)this.uriFragmentsBuilderSwitch.apply((Object)annotation.eContainer());
            segments.add(annotation.eContainmentFeature().getName());
            segments.add(annotation.getType().getName());
            return segments;
        }
        return new ArrayList<String>();
    }

    private List<String> method(Method method) {
        if (method.eContainer() != null) {
            List segments = (List)this.uriFragmentsBuilderSwitch.apply((Object)method.eContainer());
            segments.add(method.eContainmentFeature().getName());
            segments.add(method.getMethod().getLiteral());
            return segments;
        }
        return new ArrayList<String>();
    }

    private List<String> response(Response response) {
        if (response.eContainer() != null) {
            List segments = (List)this.uriFragmentsBuilderSwitch.apply((Object)response.eContainer());
            segments.add(response.eContainmentFeature().getName());
            segments.add(response.getStatusCode());
            return segments;
        }
        return new ArrayList<String>();
    }

    private List<String> body(Body body) {
        if (body.eContainer() != null) {
            List segments = (List)this.uriFragmentsBuilderSwitch.apply((Object)body.eContainer());
            segments.add(body.eContainmentFeature().getName());
            segments.add(body.getContentType());
            return segments;
        }
        return new ArrayList<String>();
    }

    private List<String> resource(Resource resource) {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(resource.eContainmentFeature().getName());
        segments.add(resource.getRelativeUri().getTemplate());
        if (resource.eContainer() instanceof Resource) {
            List parentSegments = (List)this.uriFragmentsBuilderSwitch.apply((Object)resource.eContainer());
            parentSegments.addAll(segments);
            return parentSegments;
        }
        return segments;
    }

    private List<String> defaultCase(EObject eObject) {
        if (eObject.eContainer() != null) {
            List segments = (List)this.uriFragmentsBuilderSwitch.apply((Object)eObject.eContainer());
            segments.add(eObject.eContainmentFeature().getName());
            return segments;
        }
        return new ArrayList<String>();
    }
}

