/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.model.values;

import io.vrap.rmf.raml.model.values.RegExp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class JavaRegExp
implements RegExp {
    private final Pattern compiledPattern;
    private final String pattern;

    private JavaRegExp(String pattern) {
        this.pattern = pattern;
        try {
            this.compiledPattern = !pattern.equals("") ? Pattern.compile(pattern) : null;
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean test(String value) {
        if (this.compiledPattern == null) {
            return true;
        }
        Matcher matcher = this.compiledPattern.matcher(value);
        return matcher.matches();
    }

    @Override
    public String toString() {
        return this.pattern;
    }

    public static RegExp of(String pattern) {
        return new JavaRegExp(pattern);
    }
}

