/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.model.values;

import io.vrap.rmf.raml.model.values.RegExp;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JsRegExp
implements RegExp {
    private final String pattern;
    private final ScriptEngine jsEngine;
    private final Bindings bindings;

    private JsRegExp(String pattern) {
        this.pattern = pattern;
        ScriptEngineManager engineManager = new ScriptEngineManager();
        this.jsEngine = engineManager.getEngineByName("js");
        this.bindings = this.jsEngine.createBindings();
        try {
            this.bindings.put("pattern", (Object)pattern);
            this.jsEngine.eval("var regex = new RegExp(pattern)", this.bindings);
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean test(String value) {
        this.bindings.put("value", (Object)value);
        try {
            Boolean result = (Boolean)this.jsEngine.eval("regex.test(value)", this.bindings);
            return result;
        }
        catch (ScriptException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String toString() {
        return this.pattern;
    }

    public static RegExp of(String pattern) {
        return new JsRegExp(pattern);
    }
}

