/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;

class ContentNegotiationURIHandler
extends URIHandlerImpl {
    private final String acceptedContentTypes;

    public ContentNegotiationURIHandler(String acceptedContentTypes) {
        this.acceptedContentTypes = acceptedContentTypes;
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        try {
            URL url = new URL(uri.toString());
            URLConnection urlConnection = url.openConnection();
            urlConnection.setRequestProperty("Accept", this.acceptedContentTypes);
            int timeout = this.getTimeout(options);
            if (timeout != 0) {
                urlConnection.setConnectTimeout(timeout);
                urlConnection.setReadTimeout(timeout);
            }
            InputStream result = urlConnection.getInputStream();
            Map response = this.getResponse(options);
            if (response != null) {
                response.put("TIME_STAMP", urlConnection.getLastModified());
            }
            return result;
        }
        catch (RuntimeException exception) {
            throw new Resource.IOWrappedException((Exception)exception);
        }
    }
}

