/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.persistence.antlr;

import io.vrap.antlr.utils.AntlrUtils;
import io.vrap.rmf.nodes.Node;
import io.vrap.rmf.nodes.NodeModelBuilder;
import io.vrap.rmf.nodes.antlr.NodeToken;
import io.vrap.rmf.raml.persistence.antlr.RAMLParser;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.Vocabulary;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;

public class RamlNodeTokenSource
implements TokenSource {
    private static final Pattern ANNOTATION_TYPE_REF_PATTERN = Pattern.compile("\\(([^\\)]*)\\)");
    private static final NodeModelBuilder NODE_MODEL_BUILDER = new NodeModelBuilder();
    private static Map<String, Integer> LITERAL_TO_TOKEN_TYPE = AntlrUtils.literalToTokenType((Vocabulary)RAMLParser.VOCABULARY);
    private final URI uri;
    private final List<NodeToken> tokens;
    private int index;

    public RamlNodeTokenSource(URI uri, Node node) {
        this.uri = uri;
        this.tokens = NODE_MODEL_BUILDER.asTokens(node).stream().map(this::toRamlToken).collect(Collectors.toList());
    }

    public RamlNodeTokenSource(URI uri, URIConverter uriConverter) {
        this(uri, NODE_MODEL_BUILDER.parse(uri, uriConverter));
    }

    public RamlNodeTokenSource(String input, URI uri, URIConverter uriConverter) {
        this(uri, NODE_MODEL_BUILDER.parse(input, uri, uriConverter));
    }

    private NodeToken toRamlToken(NodeToken nodeToken) {
        int type;
        String text = nodeToken.getText();
        if (nodeToken.getType() == 5) {
            Matcher matcher = ANNOTATION_TYPE_REF_PATTERN.matcher(text);
            if (LITERAL_TO_TOKEN_TYPE.containsKey(text)) {
                type = LITERAL_TO_TOKEN_TYPE.get(text);
            } else if (text.startsWith("/")) {
                type = 56;
            } else if (matcher.matches()) {
                type = 55;
                text = matcher.group(1);
            } else {
                type = 51;
            }
        } else {
            switch (nodeToken.getType()) {
                case 1: {
                    type = 47;
                    break;
                }
                case 2: {
                    type = 48;
                    break;
                }
                case 6: {
                    type = 52;
                    break;
                }
                case 8: {
                    type = 54;
                    break;
                }
                case 7: {
                    type = 53;
                    break;
                }
                case 3: {
                    type = 49;
                    break;
                }
                case 4: {
                    type = 50;
                    break;
                }
                case 9: {
                    type = 51;
                    break;
                }
                default: {
                    type = nodeToken.getType();
                }
            }
        }
        return nodeToken.withType(type, text);
    }

    public Token nextToken() {
        return this.index < this.tokens.size() ? (Token)this.tokens.get(this.index++) : new NodeToken(-1, null);
    }

    public int getLine() {
        return this.index < this.tokens.size() ? this.tokens.get(this.index).getLine() : -1;
    }

    public int getCharPositionInLine() {
        return this.index < this.tokens.size() ? this.tokens.get(this.index).getCharPositionInLine() : -1;
    }

    public CharStream getInputStream() {
        return null;
    }

    public String getSourceName() {
        return this.uri.toString();
    }

    public void setTokenFactory(TokenFactory<?> factory) {
    }

    public TokenFactory<?> getTokenFactory() {
        return null;
    }
}

