/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.persistence.constructor;

import com.google.common.base.Strings;
import io.vrap.rmf.raml.model.elements.ElementsPackage;
import io.vrap.rmf.raml.model.modules.ModulesPackage;
import io.vrap.rmf.raml.model.resources.HttpMethod;
import io.vrap.rmf.raml.model.resources.Method;
import io.vrap.rmf.raml.model.resources.Parameter;
import io.vrap.rmf.raml.model.resources.ResourceType;
import io.vrap.rmf.raml.model.resources.ResourceTypeApplication;
import io.vrap.rmf.raml.model.resources.ResourcesFactory;
import io.vrap.rmf.raml.model.resources.ResourcesPackage;
import io.vrap.rmf.raml.model.resources.Trait;
import io.vrap.rmf.raml.model.resources.TraitApplication;
import io.vrap.rmf.raml.model.responses.Body;
import io.vrap.rmf.raml.model.responses.Response;
import io.vrap.rmf.raml.model.responses.ResponsesPackage;
import io.vrap.rmf.raml.model.security.SecuredBy;
import io.vrap.rmf.raml.model.security.SecurityFactory;
import io.vrap.rmf.raml.model.security.SecurityPackage;
import io.vrap.rmf.raml.model.security.SecurityScheme;
import io.vrap.rmf.raml.model.security.SecuritySchemeDescription;
import io.vrap.rmf.raml.model.security.SecuritySchemeSettings;
import io.vrap.rmf.raml.model.security.SecuritySchemeType;
import io.vrap.rmf.raml.model.types.Annotation;
import io.vrap.rmf.raml.model.types.AnyAnnotationType;
import io.vrap.rmf.raml.model.types.AnyType;
import io.vrap.rmf.raml.model.types.BooleanInstance;
import io.vrap.rmf.raml.model.types.BuiltinType;
import io.vrap.rmf.raml.model.types.Example;
import io.vrap.rmf.raml.model.types.Instance;
import io.vrap.rmf.raml.model.types.TypesPackage;
import io.vrap.rmf.raml.model.values.RegExp;
import io.vrap.rmf.raml.persistence.antlr.RAMLParser;
import io.vrap.rmf.raml.persistence.constructor.AbstractScopedVisitor;
import io.vrap.rmf.raml.persistence.constructor.InstanceConstructor;
import io.vrap.rmf.raml.persistence.constructor.Scope;
import io.vrap.rmf.raml.persistence.constructor.TypeExpressionResolver;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class BaseConstructor
extends AbstractScopedVisitor<Object> {
    private final InstanceConstructor instanceConstructor = new InstanceConstructor();
    private final TypeExpressionResolver typeExpressionResolver = new TypeExpressionResolver();

    @Override
    public Object visitSecuredBy(RAMLParser.SecuredByContext ctx) {
        SecuredBy securedBy = (SecuredBy)this.create(SecurityPackage.Literals.SECURED_BY, ctx);
        this.scope.setValue(securedBy, ctx.getStart());
        SecurityScheme scheme = (SecurityScheme)this.scope.getEObjectByName(ctx.name.getText(), SecurityPackage.Literals.SECURITY_SCHEME);
        securedBy.setScheme(scheme);
        if (ctx.parameters != null) {
            this.instanceConstructor.withinScope(this.scope.with(securedBy, (EStructuralFeature)SecurityPackage.Literals.SECURED_BY__PARAMETERS), (T securedByParametersScope) -> this.instanceConstructor.visitObjectInstance(ctx.parameters));
        }
        return securedBy;
    }

    @Override
    public Object visitEnumFacet(RAMLParser.EnumFacetContext enumFacet) {
        return this.instanceConstructor.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.ANY_TYPE_FACET__ENUM), (T enumScope) -> enumFacet.instance().stream().map(this.instanceConstructor::visitInstance).collect(Collectors.toList()));
    }

    @Override
    public Object visitInstance(RAMLParser.InstanceContext instance) {
        return this.instanceConstructor.withinScope(this.scope, (T instanceScope) -> (Instance)this.instanceConstructor.visitInstance(instance));
    }

    @Override
    public Object visitDefaultFacet(RAMLParser.DefaultFacetContext defaultFacet) {
        return this.instanceConstructor.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.ANY_TYPE_FACET__DEFAULT), (T defaultScope) -> (Instance)this.instanceConstructor.visitInstance(defaultFacet.instance()));
    }

    @Override
    public Object visitExampleFacet(RAMLParser.ExampleFacetContext exampleFacet) {
        Example example = (Example)this.visitExample(exampleFacet.example());
        example.setName("");
        return this.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.ANY_TYPE__EXAMPLES), (T exampleScope) -> {
            exampleScope.setValue(example, exampleFacet.getStart());
            return example;
        });
    }

    @Override
    public Object visitExample(RAMLParser.ExampleContext ctx) {
        Example example = (Example)this.create(TypesPackage.Literals.EXAMPLE, ctx);
        return this.withinScope(this.scope.with(example), (T exampleScope) -> {
            ctx.displayNameFacet().forEach(this::visitDisplayNameFacet);
            ctx.descriptionFacet().forEach(this::visitDescriptionFacet);
            ctx.strictFacet().forEach(this::visitStrictFacet);
            ctx.annotationFacet().forEach(this::visitAnnotationFacet);
            if (ctx.strictFacet().isEmpty()) {
                BooleanInstance strict = (BooleanInstance)this.create(TypesPackage.Literals.BOOLEAN_INSTANCE, ctx);
                strict.setValue(true);
                example.setStrict(strict);
            }
            this.instanceConstructor.withinScope(this.scope.with(example, (EStructuralFeature)TypesPackage.Literals.VALUE_INSTANCE_FACET__VALUE), (T exampleValueScope) -> (Instance)this.instanceConstructor.visitBaseInstance(ctx.value));
            return example;
        });
    }

    @Override
    public Object visitStrictFacet(RAMLParser.StrictFacetContext ctx) {
        return this.instanceConstructor.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.STRICT_FACET__STRICT), (T strictScope) -> {
            Instance strict = this.instanceConstructor.visitAnnotatedBooleanInstance(ctx.annotatedBooleanInstance());
            return strictScope.setValue(strict, ctx.getStart());
        });
    }

    @Override
    public Object visitDescriptionFacet(RAMLParser.DescriptionFacetContext ctx) {
        return this.instanceConstructor.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.DESCRIPTION_FACET__DESCRIPTION), (T descriptionScope) -> {
            Instance description = this.instanceConstructor.visitAnnotatedStringInstance(ctx.annotatedStringInstance());
            return descriptionScope.setValue(description, ctx.getStart());
        });
    }

    @Override
    public Object visitDisplayNameFacet(RAMLParser.DisplayNameFacetContext ctx) {
        return this.instanceConstructor.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.DISPLAY_NAME_FACET__DISPLAY_NAME), (T displayNameScope) -> {
            Instance displayName = this.instanceConstructor.visitAnnotatedStringInstance(ctx.annotatedStringInstance());
            return displayNameScope.setValue(displayName, ctx.getStart());
        });
    }

    @Override
    public Object visitExamplesFacet(RAMLParser.ExamplesFacetContext examplesFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.ANY_TYPE__EXAMPLES), (T examplesScope) -> super.visitExamplesFacet(examplesFacet));
    }

    @Override
    public Object visitNamedExample(RAMLParser.NamedExampleContext namedExample) {
        Example example = (Example)this.visitExample(namedExample.example());
        example.setName(namedExample.name.getText());
        this.scope.setValue(example, namedExample.getStart());
        return example;
    }

    public abstract EObject construct(RAMLParser var1, Scope var2);

    @Override
    public Object visitTraitsFacet(RAMLParser.TraitsFacetContext traitsFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)ModulesPackage.Literals.TYPE_CONTAINER__TRAITS), (T traitsScope) -> super.visitTraitsFacet(traitsFacet));
    }

    @Override
    public Object visitTraitFacet(RAMLParser.TraitFacetContext traitFacet) {
        Trait trait = (Trait)this.scope.getEObjectByName(traitFacet.name.getText());
        return this.withinScope(this.scope.with(trait), (T traitScope) -> super.visitTraitFacet(traitFacet));
    }

    @Override
    public Object visitIsFacet(RAMLParser.IsFacetContext isFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)ResourcesPackage.Literals.APPLY_TRAITS_FACET__IS), (T isScope) -> super.visitIsFacet(isFacet));
    }

    @Override
    public Object visitTraitApplication(RAMLParser.TraitApplicationContext ctx) {
        TraitApplication traitApplication = (TraitApplication)this.create(ResourcesPackage.Literals.TRAIT_APPLICATION, ctx);
        this.scope.setValue(traitApplication, ctx.getStart());
        String traitName = ctx.trait.getText();
        Trait trait = (Trait)this.scope.with((EStructuralFeature)ResourcesPackage.Literals.TRAIT_APPLICATION__TRAIT).getEObjectByName(traitName);
        traitApplication.setTrait(trait);
        return this.withinScope(this.scope.with(traitApplication, (EStructuralFeature)ResourcesPackage.Literals.PARAMETERIZED_APPLICATION__PARAMETERS), (T argumentsScope) -> super.visitTraitApplication(ctx));
    }

    @Override
    public Object visitArgument(RAMLParser.ArgumentContext ctx) {
        Parameter traitParameter = (Parameter)this.create(ResourcesPackage.Literals.PARAMETER, ctx);
        this.scope.setValue(traitParameter, ctx.getStart());
        traitParameter.setName(ctx.name.getText());
        this.withinScope(this.scope.with(traitParameter, (EStructuralFeature)ResourcesPackage.Literals.PARAMETER__VALUE), (T valueScope) -> super.visitArgument(ctx));
        return traitParameter;
    }

    @Override
    public Object visitSecuritySchemesFacet(RAMLParser.SecuritySchemesFacetContext ctx) {
        return this.withinScope(this.scope.with((EStructuralFeature)SecurityPackage.Literals.SECURITY_SCHEME_CONTAINER__SECURITY_SCHEMES), (T scope) -> super.visitSecuritySchemesFacet(ctx));
    }

    @Override
    public Object visitSecuritySchemeFacet(RAMLParser.SecuritySchemeFacetContext securitySchemeFacet) {
        SecurityScheme securityScheme = (SecurityScheme)this.scope.getEObjectByName(securitySchemeFacet.name.getText());
        return this.withinScope(this.scope.with(securityScheme), (T securitySchemeScope) -> {
            securitySchemeFacet.attributeFacet().forEach(this::visitAttributeFacet);
            securitySchemeFacet.descriptionFacet().forEach(this::visitDescriptionFacet);
            securitySchemeFacet.displayNameFacet().forEach(this::visitDisplayNameFacet);
            securitySchemeFacet.describedByFacet().forEach(this::visitDescribedByFacet);
            this.withinScope(securitySchemeScope.with((EStructuralFeature)SecurityPackage.Literals.SECURITY_SCHEME__TYPE), (T s) -> securitySchemeFacet.securitySchemeTypeFacet().stream().map(this::visitSecuritySchemeTypeFacet).collect(Collectors.toList()));
            SecuritySchemeSettings securitySchemeSettings = null;
            switch (securityScheme.getType()) {
                case OAUTH_10: {
                    securitySchemeSettings = (SecuritySchemeSettings)this.create(SecurityPackage.Literals.OAUTH10_SETTINGS, securitySchemeFacet);
                    break;
                }
                case OAUTH_20: {
                    securitySchemeSettings = (SecuritySchemeSettings)this.create(SecurityPackage.Literals.OAUTH20_SETTINGS, securitySchemeFacet);
                    break;
                }
                default: {
                    if (securitySchemeFacet.securitySchemeSettingsFacet().size() <= 0) break;
                    this.scope.addErrorWithLocation("Settings not supported for type ''{0}''", securitySchemeFacet.getStart(), new Object[]{securityScheme.getType()});
                }
            }
            if (securitySchemeSettings != null) {
                this.scope.with((EStructuralFeature)SecurityPackage.Literals.SECURITY_SCHEME__SETTINGS).setValue(securitySchemeSettings, securitySchemeFacet.getStart());
                this.withinScope(this.scope.with(securitySchemeSettings), (T settingsScope) -> securitySchemeFacet.securitySchemeSettingsFacet().stream().map(this::visitSecuritySchemeSettingsFacet).collect(Collectors.toList()));
            }
            return securitySchemeScope.getEObject();
        });
    }

    @Override
    public Object visitDescribedByFacet(RAMLParser.DescribedByFacetContext describedByFacet) {
        SecuritySchemeDescription securitySchemeDescription = (SecuritySchemeDescription)this.create(SecurityPackage.Literals.SECURITY_SCHEME_DESCRIPTION, describedByFacet);
        this.scope.with((EStructuralFeature)SecurityPackage.Literals.SECURITY_SCHEME__DESCRIBED_BY).setValue(securitySchemeDescription, describedByFacet.getStart());
        return this.withinScope(this.scope.with(securitySchemeDescription), (T securitySchemeDescriptionScope) -> super.visitDescribedByFacet(describedByFacet));
    }

    @Override
    public Object visitResponsesFacet(RAMLParser.ResponsesFacetContext responsesFacetContext) {
        return this.withinScope(this.scope.with((EStructuralFeature)ResponsesPackage.Literals.RESPONSES_FACET__RESPONSES), (T responsesScope) -> super.visitResponsesFacet(responsesFacetContext));
    }

    @Override
    public Object visitResponseFacet(RAMLParser.ResponseFacetContext responseFacet) {
        Response response = (Response)this.create(ResponsesPackage.Literals.RESPONSE, responseFacet);
        this.scope.setValue(response, responseFacet.getStart());
        response.setStatusCode(responseFacet.statusCode.getText());
        return this.withinScope(this.scope.with(response), (T responseScope) -> super.visitResponseFacet(responseFacet));
    }

    @Override
    public Object visitBodyFacet(RAMLParser.BodyFacetContext ctx) {
        return this.withinScope(this.scope.with((EStructuralFeature)ResponsesPackage.Literals.BODY_CONTAINER__BODIES), (T bodiesScope) -> super.visitBodyFacet(ctx));
    }

    @Override
    public Object visitBodyContentTypeFacet(RAMLParser.BodyContentTypeFacetContext bodyContentType) {
        Body body;
        RAMLParser.BodyFacetsContext bodyFacets = bodyContentType.bodyFacets();
        if (bodyFacets != null) {
            body = (Body)this.visitBodyFacets(bodyFacets);
        } else {
            body = (Body)this.create(ResponsesPackage.Literals.BODY, bodyContentType);
            this.scope.setValue(body, bodyContentType.getStart());
        }
        String contentTypeText = bodyContentType.contentType.getText();
        if (!Strings.isNullOrEmpty((String)contentTypeText)) {
            body.setContentType(contentTypeText);
        }
        return body;
    }

    @Override
    public Object visitBodyFacets(RAMLParser.BodyFacetsContext bodyFacet) {
        Body body = (Body)this.create(ResponsesPackage.Literals.BODY, bodyFacet);
        this.scope.setValue(body, bodyFacet.getStart());
        return this.withinScope(this.scope.with(body), (T bodyScope) -> {
            boolean isInlineTypeDeclaration;
            AnyType type = (AnyType)this.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__TYPE), (T typedElementTypeScope) -> {
                AnyType anyType = null;
                if (bodyFacet.typeFacet().size() == 1) {
                    anyType = (AnyType)this.visitTypeFacet(bodyFacet.typeFacet(0));
                } else if (bodyFacet.propertiesFacet().size() == 1) {
                    anyType = BuiltinType.OBJECT.getType(this.scope.getResourceSet());
                }
                if (anyType == null) {
                    anyType = BuiltinType.ANY.getType(this.scope.getResourceSet());
                }
                return anyType;
            });
            boolean bl = isInlineTypeDeclaration = bodyFacet.attributeFacet().size() > 0 || bodyFacet.propertiesFacet().size() > 0 || bodyFacet.exampleFacet().size() > 0 || bodyFacet.examplesFacet().size() > 0 || bodyFacet.defaultFacet().size() > 0 || bodyFacet.enumFacet().size() > 0 || bodyFacet.descriptionFacet().size() > 0 || bodyFacet.itemsFacet().size() > 0;
            if (isInlineTypeDeclaration) {
                type = this.inlineTypeDeclaration(type, (Scope)bodyScope, bodyFacet);
            }
            this.withinScope(this.scope.with(type), (T inlineTypeDeclarationScope) -> super.visitBodyFacets(bodyFacet));
            bodyScope.with((EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__TYPE).setValue(type, bodyFacet.getStart());
            return body;
        });
    }

    private AnyType inlineTypeDeclaration(AnyType type, Scope scope, ParserRuleContext ruleContext) {
        if (type.isInlineType()) {
            return type;
        }
        AnyType inlinedType = (AnyType)this.createAndCopy(type, ruleContext);
        scope.with(inlinedType, (EStructuralFeature)TypesPackage.Literals.ANY_TYPE__TYPE).setValue(type, ruleContext.getStart());
        scope.addValue((EStructuralFeature)TypesPackage.Literals.INLINE_TYPE_CONTAINER__INLINE_TYPES, inlinedType);
        return inlinedType;
    }

    protected EObject createAndCopy(EObject eObject, ParserRuleContext ruleContext) {
        EClass eClass = eObject.eClass();
        Object newEObject = this.create(eClass, ruleContext);
        Consumer<EAttribute> copyAttribute = attribute -> newEObject.eSet((EStructuralFeature)attribute, eObject.eGet((EStructuralFeature)attribute));
        eClass.getEAllAttributes().forEach(copyAttribute);
        return newEObject;
    }

    @Override
    public Object visitHeadersFacet(RAMLParser.HeadersFacetContext headersFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.HEADERS_FACET__HEADERS), (T headersScope) -> super.visitHeadersFacet(headersFacet));
    }

    @Override
    public Object visitQueryParametersFacet(RAMLParser.QueryParametersFacetContext queryParametersFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.QUERY_PARAMETERS_FACET__QUERY_PARAMETERS), (T queryParametersScope) -> super.visitQueryParametersFacet(queryParametersFacet));
    }

    @Override
    public Object visitSecuritySchemeSettingsFacet(RAMLParser.SecuritySchemeSettingsFacetContext securitySchemeSettingsFacet) {
        securitySchemeSettingsFacet.attributeFacet().forEach(this::visitAttributeFacet);
        securitySchemeSettingsFacet.annotationFacet().forEach(this::visitAnnotationFacet);
        return this.scope.getEObject();
    }

    @Override
    public Object visitSecuritySchemeTypeFacet(RAMLParser.SecuritySchemeTypeFacetContext securitySchemeTypeFacet) {
        String securityTypeText = securitySchemeTypeFacet.type.getText();
        try {
            SecuritySchemeType securitySchemeType = (SecuritySchemeType)((Object)SecurityFactory.eINSTANCE.createFromString((EDataType)SecurityPackage.Literals.SECURITY_SCHEME_TYPE, securityTypeText));
            this.scope.setValue(securitySchemeType, securitySchemeTypeFacet.getStart());
            return securitySchemeType;
        }
        catch (IllegalArgumentException e) {
            this.scope.addErrorWithLocation(e.getMessage(), securitySchemeTypeFacet.getStart(), new Object[0]);
            return null;
        }
    }

    @Override
    public Object visitSecuredByFacet(RAMLParser.SecuredByFacetContext securedByFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)SecurityPackage.Literals.SECURED_BY_FACET__SECURED_BY), (T securedByScope) -> super.visitSecuredByFacet(securedByFacet));
    }

    @Override
    public Object visitAnnotationFacet(RAMLParser.AnnotationFacetContext annotationFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.ANNOTATIONS_FACET__ANNOTATIONS), (T annotationsScope) -> {
            Annotation annotation = (Annotation)this.create(TypesPackage.Literals.ANNOTATION, annotationFacet);
            this.scope.setValue(annotation, annotationFacet.getStart());
            String annotationTypeRef = annotationFacet.ANNOTATION_TYPE_REF().getText();
            Scope annotationTypeScope = annotationsScope.with((EStructuralFeature)TypesPackage.Literals.ANNOTATION__TYPE);
            AnyAnnotationType annotationType = (AnyAnnotationType)annotationTypeScope.getEObjectByName(annotationTypeRef);
            annotation.setType(annotationType);
            this.withinScope(annotationsScope.with(annotation, (EStructuralFeature)TypesPackage.Literals.ANNOTATION__VALUE), (T annotationValueScope) -> this.visitInstance(annotationFacet.value));
            return annotation;
        });
    }

    @Override
    public Object visitTypesFacet(RAMLParser.TypesFacetContext typesFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)ModulesPackage.Literals.TYPE_CONTAINER__TYPES), (T typesScope) -> super.visitTypesFacet(typesFacet));
    }

    @Override
    public Object visitAnnotationTypesFacet(RAMLParser.AnnotationTypesFacetContext annotationTypesFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)ModulesPackage.Literals.TYPE_CONTAINER__ANNOTATION_TYPES), (T typesScope) -> super.visitAnnotationTypesFacet(annotationTypesFacet));
    }

    @Override
    public Object visitTypeFacet(RAMLParser.TypeFacetContext ctx) {
        String typeExpression = ctx.typeExpression().getText();
        EObject parsedTypeExpression = this.typeExpressionResolver.resolve(typeExpression, this.scope);
        return parsedTypeExpression;
    }

    @Override
    public Object visitItemsFacet(RAMLParser.ItemsFacetContext itemsFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.ARRAY_TYPE_FACET__ITEMS), (T itemsScope) -> {
            EObject itemsType;
            if (itemsFacet.typeExpression() != null) {
                String typeExpression = itemsFacet.typeExpression().getText();
                itemsType = this.typeExpressionResolver.resolve(typeExpression, this.scope);
            } else {
                boolean isInlineTypeDeclaration;
                AnyType typedElementType;
                if (itemsFacet.typeFacet().size() > 0) {
                    RAMLParser.TypeFacetContext typeFacet = itemsFacet.typeFacet().get(0);
                    typedElementType = (EObject)this.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__TYPE), (T propertyTypeScope) -> this.visitTypeFacet(typeFacet));
                } else {
                    typedElementType = itemsFacet.propertiesFacet().size() == 1 ? BuiltinType.OBJECT.getType(this.scope.getResourceSet()) : BuiltinType.STRING.getType(this.scope.getResourceSet());
                }
                boolean bl = isInlineTypeDeclaration = itemsFacet.attributeFacet().size() > 0 || itemsFacet.propertiesFacet().size() > 0 || itemsFacet.exampleFacet().size() > 0 || itemsFacet.examplesFacet().size() > 0 || itemsFacet.defaultFacet().size() > 0 || itemsFacet.enumFacet().size() > 0 || itemsFacet.descriptionFacet().size() > 0 || itemsFacet.displayNameFacet().size() > 0 || itemsFacet.itemsFacet().size() > 0;
                if (isInlineTypeDeclaration) {
                    typedElementType = this.create(typedElementType.eClass(), itemsFacet);
                    this.scope.addValue((EStructuralFeature)TypesPackage.Literals.INLINE_TYPE_CONTAINER__INLINE_TYPES, typedElementType);
                    this.withinScope(this.scope.with(typedElementType), (T inlineTypeDeclarationScope) -> super.visitItemsFacet(itemsFacet));
                }
                itemsType = typedElementType;
            }
            this.scope.setValue(itemsType, itemsFacet.getStart());
            return itemsType;
        });
    }

    @Override
    public Object visitTypeDeclarationTuple(RAMLParser.TypeDeclarationTupleContext typeDeclarationTuple) {
        EObject declaredType = this.scope.getEObjectByName(typeDeclarationTuple.name.getText());
        return declaredType;
    }

    @Override
    public Object visitTypeDeclarationMap(RAMLParser.TypeDeclarationMapContext typeDeclarationMap) {
        String text = typeDeclarationMap.name.getText();
        EObject declaredType = this.scope.getEObjectByName(text);
        return this.withinScope(this.scope.with(declaredType), (T typeScope) -> super.visitTypeDeclarationMap(typeDeclarationMap));
    }

    @Override
    public Object visitPropertiesFacet(RAMLParser.PropertiesFacetContext propertiesFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.OBJECT_TYPE_FACET__PROPERTIES), (T propertiesScope) -> super.visitPropertiesFacet(propertiesFacet));
    }

    @Override
    public Object visitTypedElementFacet(RAMLParser.TypedElementFacetContext typedElementFacet) {
        EClass eType = (EClass)this.scope.getFeature().getEType();
        Object typedElement = this.create(eType, typedElementFacet);
        this.scope.setValue(typedElement, typedElementFacet.getStart());
        return this.withinScope(this.scope.with((EObject)typedElement, (EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__TYPE), (T propertyScope) -> super.visitTypedElementFacet(typedElementFacet));
    }

    @Override
    public Object visitTypedElementTuple(RAMLParser.TypedElementTupleContext typedeElementTuple) {
        Token type = typedeElementTuple.type.start;
        String name = typedeElementTuple.name.getText();
        AnyType propertyType = Strings.isNullOrEmpty((String)type.getText()) ? BuiltinType.STRING.getType(this.scope.getResourceSet()) : this.typeExpressionResolver.resolve(type.getText(), this.scope);
        boolean isRequired = !name.endsWith("?");
        this.scope.setValue((EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__REQUIRED, Boolean.valueOf(isRequired), typedeElementTuple.getStart());
        String parsedName = isRequired ? name : name.substring(0, name.length() - 1);
        this.scope.setValue((EStructuralFeature)ElementsPackage.Literals.NAMED_ELEMENT__NAME, parsedName, typedeElementTuple.getStart());
        this.setTypedElementPattern(name, typedeElementTuple.getStart());
        this.scope.setValue((EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__TYPE, propertyType, typedeElementTuple.getStart());
        return this.scope.getEObject();
    }

    private void setTypedElementPattern(String name, Token nameStart) {
        if (name.startsWith("/") && name.endsWith("/")) {
            RegExp pattern = RegExp.of(name.substring(1, name.length() - 1));
            this.scope.setValue((EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__PATTERN, pattern, nameStart);
        }
    }

    @Override
    public Object visitTypedElementMap(RAMLParser.TypedElementMapContext typedElementMap) {
        boolean isInlineTypeDeclaration;
        AnyType typedElementType;
        String parsedName;
        Boolean requiredValue;
        String name = typedElementMap.name.getText();
        Boolean bl = requiredValue = typedElementMap.requiredFacet().size() == 1 ? Boolean.valueOf(Boolean.parseBoolean(typedElementMap.requiredFacet().get((int)0).required.getText())) : null;
        if (requiredValue == null) {
            boolean isRequired = !name.endsWith("?");
            this.scope.setValue((EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__REQUIRED, Boolean.valueOf(isRequired), typedElementMap.getStart());
            parsedName = isRequired ? name : name.substring(0, name.length() - 1);
        } else {
            parsedName = name;
            this.scope.setValue((EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__REQUIRED, requiredValue, typedElementMap.getStart());
        }
        this.scope.setValue((EStructuralFeature)ElementsPackage.Literals.NAMED_ELEMENT__NAME, parsedName, typedElementMap.getStart());
        this.setTypedElementPattern(name, typedElementMap.getStart());
        if (typedElementMap.typeFacet().size() > 0) {
            RAMLParser.TypeFacetContext typeFacet = typedElementMap.typeFacet().get(0);
            typedElementType = (AnyType)this.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__TYPE), (T propertyTypeScope) -> this.visitTypeFacet(typeFacet));
        } else {
            typedElementType = typedElementMap.propertiesFacet().size() == 1 ? BuiltinType.OBJECT.getType(this.scope.getResourceSet()) : BuiltinType.STRING.getType(this.scope.getResourceSet());
        }
        boolean bl2 = isInlineTypeDeclaration = typedElementMap.attributeFacet().size() > 0 || typedElementMap.propertiesFacet().size() > 0 || typedElementMap.exampleFacet().size() > 0 || typedElementMap.examplesFacet().size() > 0 || typedElementMap.defaultFacet().size() > 0 || typedElementMap.enumFacet().size() > 0 || typedElementMap.displayNameFacet().size() > 0 || typedElementMap.descriptionFacet().size() > 0 || typedElementMap.itemsFacet().size() > 0;
        if (isInlineTypeDeclaration) {
            typedElementType = this.inlineTypeDeclaration(typedElementType, this.scope, typedElementMap);
            this.scope.addValue((EStructuralFeature)TypesPackage.Literals.INLINE_TYPE_CONTAINER__INLINE_TYPES, typedElementType);
            this.withinScope(this.scope.with(typedElementType), (T inlineTypeDeclarationScope) -> super.visitTypedElementMap(typedElementMap));
        } else {
            super.visitTypedElementMap(typedElementMap);
        }
        this.scope.setValue((EStructuralFeature)TypesPackage.Literals.TYPED_ELEMENT__TYPE, typedElementType, typedElementMap.getStart());
        return this.scope.getEObject();
    }

    @Override
    public Object visitAttributeFacet(RAMLParser.AttributeFacetContext attributeFacet) {
        Object value = this.setAttribute(attributeFacet, this.scope.getEObject());
        return value;
    }

    @Override
    public Object visitResourceTypesFacet(RAMLParser.ResourceTypesFacetContext ctx) {
        return this.withinScope(this.scope.with((EStructuralFeature)ModulesPackage.Literals.TYPE_CONTAINER__RESOURCE_TYPES), (T resourceTypesScope) -> super.visitResourceTypesFacet(ctx));
    }

    @Override
    public Object visitResourceTypeFacet(RAMLParser.ResourceTypeFacetContext ctx) {
        return this.withinScope(this.scope.with((EStructuralFeature)ResourcesPackage.Literals.RESOURCE_BASE__TYPE), (T resourceTypeScope) -> super.visitResourceTypeFacet(ctx));
    }

    @Override
    public Object visitResourceTypeApplication(RAMLParser.ResourceTypeApplicationContext ctx) {
        ResourceTypeApplication resourceTypeApplication = (ResourceTypeApplication)this.create(ResourcesPackage.Literals.RESOURCE_TYPE_APPLICATION, ctx);
        this.scope.setValue(resourceTypeApplication, ctx.getStart());
        ResourceType resourceType = (ResourceType)this.scope.with((EStructuralFeature)ResourcesPackage.Literals.RESOURCE_TYPE_APPLICATION__TYPE).getEObjectByName(ctx.type.getText());
        resourceTypeApplication.setType(resourceType);
        return this.withinScope(this.scope.with(resourceTypeApplication, (EStructuralFeature)ResourcesPackage.Literals.PARAMETERIZED_APPLICATION__PARAMETERS), (T argumentsScope) -> super.visitResourceTypeApplication(ctx));
    }

    @Override
    public Object visitResourceTypeDeclarationFacet(RAMLParser.ResourceTypeDeclarationFacetContext resourceTypeDeclarationFacet) {
        String type = resourceTypeDeclarationFacet.name.getText();
        EObject resourceType = this.scope.getEObjectByName(type);
        return this.withinScope(this.scope.with(resourceType), (T resourceTypeScope) -> super.visitResourceTypeDeclarationFacet(resourceTypeDeclarationFacet));
    }

    @Override
    public Object visitMethodFacet(RAMLParser.MethodFacetContext methodFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)ResourcesPackage.Literals.RESOURCE_BASE__METHODS), (T methodsScope) -> {
            Method method = (Method)this.create(ResourcesPackage.Literals.METHOD, methodFacet);
            String httpMethodText = methodFacet.httpMethod().getText();
            boolean required = !httpMethodText.endsWith("?");
            method.setRequired(required);
            httpMethodText = required ? httpMethodText : httpMethodText.substring(0, httpMethodText.length() - 1);
            HttpMethod httpMethod = (HttpMethod)((Object)((Object)ResourcesFactory.eINSTANCE.createFromString((EDataType)ResourcesPackage.Literals.HTTP_METHOD, httpMethodText)));
            method.setMethod(httpMethod);
            methodsScope.setValue(method, methodFacet.getStart());
            this.withinScope(methodsScope.with(method), (T methodScope) -> super.visitMethodFacet(methodFacet));
            return method;
        });
    }

    private Object setAttribute(RAMLParser.AttributeFacetContext attributeFacet, EObject eObject) {
        Object value;
        EClass eClass = eObject.eClass();
        String attributeName = attributeFacet.facet.getText();
        EAttribute eAttribute = eClass.getEAllAttributes().stream().filter(a -> a.getName().equals(attributeName)).findFirst().orElse(null);
        if (eAttribute == null) {
            this.scope.addErrorWithLocation("Unknown attribute ''{0}''", attributeFacet.getStart(), attributeName);
            value = null;
        } else {
            Object object = value = attributeFacet.facetValue().value == null ? attributeFacet.facetValue().values : attributeFacet.facetValue().value;
            if (attributeFacet.facetValue().anyValue().size() == 1) {
                this.setAttribute(eObject, eAttribute, attributeFacet.facetValue().anyValue().get(0));
            } else {
                this.setAttribute(eObject, eAttribute, attributeFacet.facetValue().anyValue());
            }
        }
        return value;
    }

    private void setAttribute(EObject eObject, EAttribute eAttribute, List<RAMLParser.AnyValueContext> valueTokens) {
        if (eAttribute.isMany()) {
            List values = valueTokens.stream().map(v -> this.createFromString(eAttribute, (RAMLParser.AnyValueContext)((Object)v))).collect(Collectors.toList());
            eObject.eSet((EStructuralFeature)eAttribute, values);
        } else {
            String messagePattern = "Trying to set attribute ''{0}'' with multiple  values";
            if (valueTokens.isEmpty()) {
                this.scope.addError("Trying to set attribute ''{0}'' with multiple  values", eAttribute);
            } else {
                this.scope.addErrorWithLocation("Trying to set attribute ''{0}'' with multiple  values", valueTokens.get(0).getStart(), eAttribute);
            }
        }
    }

    private void setAttribute(EObject eObject, EAttribute eAttribute, RAMLParser.AnyValueContext anyValueContext) {
        if (anyValueContext.getText().length() > 0) {
            Object value = this.createFromString(eAttribute, anyValueContext);
            if (eAttribute.isMany()) {
                eObject.eSet((EStructuralFeature)eAttribute, Collections.singletonList(value));
            } else {
                eObject.eSet((EStructuralFeature)eAttribute, value);
            }
        }
    }

    private Object createFromString(EAttribute eAttribute, RAMLParser.AnyValueContext anyValueContext) {
        try {
            return EcoreUtil.createFromString((EDataType)eAttribute.getEAttributeType(), (String)anyValueContext.getText());
        }
        catch (IllegalArgumentException e) {
            this.scope.addErrorWithLocation(e.getMessage(), anyValueContext.getStart(), new Object[0]);
            return null;
        }
    }
}

