/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.persistence.constructor;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.vrap.rmf.raml.model.elements.ElementsPackage;
import io.vrap.rmf.raml.model.modules.Api;
import io.vrap.rmf.raml.model.modules.Extension;
import io.vrap.rmf.raml.model.modules.Library;
import io.vrap.rmf.raml.model.modules.LibraryUse;
import io.vrap.rmf.raml.model.modules.ModulesPackage;
import io.vrap.rmf.raml.model.resources.ResourceType;
import io.vrap.rmf.raml.model.resources.ResourcesPackage;
import io.vrap.rmf.raml.model.resources.Trait;
import io.vrap.rmf.raml.model.security.SecurityPackage;
import io.vrap.rmf.raml.model.security.SecurityScheme;
import io.vrap.rmf.raml.model.types.AnyType;
import io.vrap.rmf.raml.model.types.ArrayType;
import io.vrap.rmf.raml.model.types.BuiltinType;
import io.vrap.rmf.raml.model.types.IntersectionType;
import io.vrap.rmf.raml.model.types.TypesPackage;
import io.vrap.rmf.raml.model.types.UnionType;
import io.vrap.rmf.raml.model.types.util.TypesSwitch;
import io.vrap.rmf.raml.persistence.antlr.RAMLParser;
import io.vrap.rmf.raml.persistence.constructor.AbstractScopedVisitor;
import io.vrap.rmf.raml.persistence.constructor.RamlParserAdapter;
import io.vrap.rmf.raml.persistence.constructor.Scope;
import io.vrap.rmf.raml.persistence.constructor.TypeExpressionResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DeclarationResolver {
    private final TypeExpressionResolver typeExpressionResolver = new TypeExpressionResolver();
    private final Multimap<RAMLParser.TypeDeclarationFacetContext, EObject> unresolvedTypeDeclarations = ArrayListMultimap.create();

    public void resolve(ParserRuleContext ruleContext, Scope scope) {
        DeclarationConstructingVisitor declarationConstructingVisitor = new DeclarationConstructingVisitor(scope);
        EObject rootObject = (EObject)declarationConstructingVisitor.visit((ParseTree)ruleContext);
        int unresolvedTypes = this.unresolvedTypeDeclarations.size();
        int newUnresolvedTypes = 0;
        while (newUnresolvedTypes < unresolvedTypes) {
            unresolvedTypes = this.unresolvedTypeDeclarations.size();
            ArrayListMultimap typeDeclarationsToResolve = ArrayListMultimap.create(this.unresolvedTypeDeclarations);
            for (RAMLParser.TypeDeclarationFacetContext typeDeclarationFacet : typeDeclarationsToResolve.keySet()) {
                for (EObject unresolved : typeDeclarationsToResolve.get((Object)typeDeclarationFacet)) {
                    TypeResolvingVisitor typeResolvingVisitor = new TypeResolvingVisitor(unresolved, scope.with(rootObject));
                    EObject resolvedType = (EObject)typeResolvingVisitor.visitTypeDeclarationFacet(typeDeclarationFacet);
                    if (resolvedType == null || resolvedType.eIsProxy()) continue;
                    this.unresolvedTypeDeclarations.remove((Object)typeDeclarationFacet, (Object)unresolved);
                }
            }
            newUnresolvedTypes = this.unresolvedTypeDeclarations.size();
        }
    }

    private EObject getType(RAMLParser.TypeDeclarationMapContext typeDeclarationMap, Scope scope) {
        String typeExpression;
        if (typeDeclarationMap.typeFacet().size() == 1) {
            RAMLParser.TypeFacetContext typeFacet = typeDeclarationMap.typeFacet().get(0);
            typeExpression = this.getTypeExpression(typeFacet.typeExpression());
        } else {
            typeExpression = typeDeclarationMap.propertiesFacet().size() == 1 ? BuiltinType.OBJECT.getName() : BuiltinType.STRING.getName();
        }
        EObject resolved = this.typeExpressionResolver.resolve(typeExpression, scope);
        if (resolved != null && !resolved.eIsProxy()) {
            this.setTypeName(resolved, typeDeclarationMap.name.start);
            this.setType(resolved, typeExpression, typeDeclarationMap.getStart(), scope);
            RamlParserAdapter adapter = RamlParserAdapter.of(typeDeclarationMap);
            resolved.eAdapters().add((Object)adapter);
        }
        return resolved;
    }

    private String getTypeExpression(RAMLParser.TypeExpressionContext typeExpressionContext) {
        String typeExpression;
        List<RAMLParser.IdContext> expressions = typeExpressionContext.id();
        if (expressions.size() > 1) {
            StringJoiner stringJoiner = new StringJoiner(",", "[", "]");
            expressions.forEach(e -> stringJoiner.add(e.getText()));
            typeExpression = stringJoiner.toString();
        } else {
            typeExpression = expressions.isEmpty() ? null : expressions.get(0).getText();
        }
        return typeExpression;
    }

    private EObject getType(RAMLParser.TypeDeclarationTupleContext typeDeclarationTuple, Scope scope) {
        Token typeExpressionToken = typeDeclarationTuple.typeExpression().start;
        String typeExpression = typeExpressionToken.getText().isEmpty() ? BuiltinType.STRING.getName() : typeExpressionToken.getText();
        EObject resolved = this.typeExpressionResolver.resolve(typeExpression, scope);
        if (resolved != null && !resolved.eIsProxy()) {
            this.setTypeName(resolved, typeDeclarationTuple.name.start);
            this.setType(resolved, typeExpression, typeExpressionToken, scope);
            RamlParserAdapter adapter = RamlParserAdapter.of(typeDeclarationTuple);
            resolved.eAdapters().add((Object)adapter);
        }
        return resolved;
    }

    private void setType(EObject resolved, String typeExpression, Token typeExpressionToken, Scope scope) {
        Scope anyTypeTypeScope;
        EObject resolvedType;
        if (resolved instanceof AnyType && (resolvedType = this.typeExpressionResolver.resolve(typeExpression, anyTypeTypeScope = scope.with(resolved, (EStructuralFeature)TypesPackage.Literals.ANY_TYPE__TYPE))) != null) {
            anyTypeTypeScope.setValue(resolvedType, typeExpressionToken);
        }
    }

    private void setTypeName(EObject resolved, Token nameToken) {
        String name = nameToken.getText();
        resolved.eSet((EStructuralFeature)ElementsPackage.Literals.NAMED_ELEMENT__NAME, (Object)name);
    }

    private class TypeResolvingVisitor
    extends AbstractScopedVisitor<EObject> {
        private final EObject unresolved;

        private TypeResolvingVisitor(EObject unresolved, Scope rootScope) {
            this.unresolved = unresolved;
            this.scope = rootScope;
        }

        @Override
        public EObject visitAnnotationTypesFacet(RAMLParser.AnnotationTypesFacetContext ctx) {
            return null;
        }

        @Override
        public EObject visitTypeDeclarationTuple(RAMLParser.TypeDeclarationTupleContext typeDeclarationTuple) {
            return this.withinScope(this.scope.with((EStructuralFeature)ModulesPackage.Literals.TYPE_CONTAINER__TYPES), typesScope -> this.resolveType(typeDeclarationTuple, DeclarationResolver.this.getType(typeDeclarationTuple, typesScope)));
        }

        @Override
        public EObject visitTypeDeclarationMap(RAMLParser.TypeDeclarationMapContext typeDeclarationMap) {
            return this.withinScope(this.scope.with((EStructuralFeature)ModulesPackage.Literals.TYPE_CONTAINER__TYPES), typesScope -> this.resolveType(typeDeclarationMap, DeclarationResolver.this.getType(typeDeclarationMap, typesScope)));
        }

        private EObject resolveType(ParserRuleContext ruleContext, EObject resolvedType) {
            if (resolvedType != null && !resolvedType.eIsProxy()) {
                EcoreUtil.replace((EObject)this.unresolved, (EObject)resolvedType);
                Token nameToken = ruleContext.getStart();
                String name = nameToken.getText();
                Scope typeScope = this.scope.with(resolvedType, (EStructuralFeature)ElementsPackage.Literals.NAMED_ELEMENT__NAME);
                typeScope.setValue(name, nameToken);
            }
            return resolvedType;
        }
    }

    private static class UnresolvedTypesCollector
    extends TypesSwitch<List<EObject>> {
        private UnresolvedTypesCollector() {
        }

        public List<EObject> doSwitch(EObject eObject) {
            return eObject != null ? (List)super.doSwitch(eObject) : Collections.emptyList();
        }

        @Override
        public List<EObject> defaultCase(EObject eObject) {
            return eObject.eIsProxy() ? Collections.singletonList(eObject) : Collections.emptyList();
        }

        @Override
        public List<EObject> caseArrayType(ArrayType arrayType) {
            return this.doSwitch(arrayType.getItems());
        }

        @Override
        public List<EObject> caseIntersectionType(IntersectionType intersectionType) {
            return intersectionType.getAllOf().stream().map(eObject -> this.doSwitch((EObject)eObject)).flatMap(Collection::stream).collect(Collectors.toList());
        }

        @Override
        public List<EObject> caseUnionType(UnionType unionType) {
            return unionType.getOneOf().stream().map(eObject -> this.doSwitch((EObject)eObject)).flatMap(Collection::stream).collect(Collectors.toList());
        }
    }

    private class DeclarationConstructingVisitor
    extends AbstractScopedVisitor<Object> {
        private final UnresolvedTypesCollector unresolvedTypesCollector = new UnresolvedTypesCollector();

        public DeclarationConstructingVisitor(Scope scope) {
            this.scope = scope;
        }

        @Override
        public Object visitLibrary(RAMLParser.LibraryContext ctx) {
            Library library = (Library)this.create(ModulesPackage.Literals.LIBRARY, ctx);
            this.scope.getResource().getContents().add((Object)library);
            this.withinScope(this.scope.with(library), libraryScope -> super.visitLibrary(ctx));
            return library;
        }

        @Override
        public Object visitApi(RAMLParser.ApiContext ctx) {
            Api api = (Api)this.create(ModulesPackage.Literals.API, ctx);
            this.scope.getResource().getContents().add((Object)api);
            this.withinScope(this.scope.with(api), apiScope -> super.visitApi(ctx));
            return api;
        }

        @Override
        public Object visitMediaTypeFacet(RAMLParser.MediaTypeFacetContext ctx) {
            List mediaTypes = ctx.types.stream().map(RuleContext::getText).collect(Collectors.toList());
            this.scope.setValue((EStructuralFeature)ModulesPackage.Literals.API_BASE__MEDIA_TYPE, mediaTypes, ctx.start);
            return super.visitMediaTypeFacet(ctx);
        }

        @Override
        public Object visitExtension(RAMLParser.ExtensionContext ctx) {
            Extension extension = (Extension)this.create(ModulesPackage.Literals.EXTENSION, ctx);
            this.scope.getResource().getContents().add((Object)extension);
            this.withinScope(this.scope.with(extension), extensionScope -> super.visitExtension(ctx));
            return extension;
        }

        @Override
        public Object visitLibraryUse(RAMLParser.LibraryUseContext libraryUseFacet) {
            String libraryUri = libraryUseFacet.libraryUri.getText();
            Resource libraryResource = this.scope.getResource(libraryUri);
            EList libraryResourceContents = libraryResource.getContents();
            LibraryUse libraryUse = (LibraryUse)this.create(ModulesPackage.Literals.LIBRARY_USE, libraryUseFacet);
            libraryUse.setName(libraryUseFacet.name.getText());
            if (libraryResourceContents.size() == 1 && libraryResourceContents.get(0) instanceof Library) {
                Library library = (Library)libraryResourceContents.get(0);
                libraryUse.setLibrary(library);
            }
            this.scope.with((EStructuralFeature)ModulesPackage.Literals.TYPE_CONTAINER__USES).setValue(libraryUse, libraryUseFacet.name.getStart());
            return libraryUse;
        }

        @Override
        public Object visitResourceTypesFacet(RAMLParser.ResourceTypesFacetContext resourceTypesFacet) {
            return this.withinScope(this.scope.with((EStructuralFeature)ModulesPackage.Literals.TYPE_CONTAINER__RESOURCE_TYPES), resourceTypesScope -> super.visitResourceTypesFacet(resourceTypesFacet));
        }

        @Override
        public Object visitResourceTypeDeclarationFacet(RAMLParser.ResourceTypeDeclarationFacetContext resourceTypeDeclarationFacet) {
            ResourceType resourceType = (ResourceType)this.create(ResourcesPackage.Literals.RESOURCE_TYPE, resourceTypeDeclarationFacet);
            this.scope.setValue(resourceType, resourceTypeDeclarationFacet.getStart());
            resourceType.setName(resourceTypeDeclarationFacet.name.getText());
            return resourceType;
        }

        @Override
        public Object visitTraitsFacet(RAMLParser.TraitsFacetContext ctx) {
            return this.withinScope(this.scope.with((EStructuralFeature)ModulesPackage.Literals.TYPE_CONTAINER__TRAITS), traitScope -> super.visitTraitsFacet(ctx));
        }

        @Override
        public Object visitTraitFacet(RAMLParser.TraitFacetContext traitFacet) {
            Trait trait = (Trait)this.create(ResourcesPackage.Literals.TRAIT, traitFacet);
            this.scope.setValue(trait, traitFacet.getStart());
            trait.setName(traitFacet.name.getText());
            return trait;
        }

        @Override
        public Object visitTypesFacet(RAMLParser.TypesFacetContext typesFacet) {
            return this.withinScope(this.scope.with((EStructuralFeature)ModulesPackage.Literals.TYPE_CONTAINER__TYPES), typesScope -> {
                List types = typesFacet.types.stream().map(this::visitTypeDeclarationFacet).collect(Collectors.toList());
                return types;
            });
        }

        @Override
        public Object visitAnnotationTypesFacet(RAMLParser.AnnotationTypesFacetContext annotationTypesFacet) {
            return this.withinScope(this.scope.with((EStructuralFeature)ModulesPackage.Literals.TYPE_CONTAINER__ANNOTATION_TYPES), typesScope -> {
                List types = annotationTypesFacet.annotationTypes.stream().map(this::visitTypeDeclarationFacet).collect(Collectors.toList());
                return types;
            });
        }

        @Override
        public Object visitTypeDeclarationFacet(RAMLParser.TypeDeclarationFacetContext typeDeclarationFacet) {
            EObject eObject = (EObject)super.visitTypeDeclarationFacet(typeDeclarationFacet);
            List<EObject> unresolvedTypes = this.getUnresolvedTypes(eObject);
            if (unresolvedTypes.isEmpty()) {
                DeclarationResolver.this.unresolvedTypeDeclarations.removeAll((Object)typeDeclarationFacet);
            } else {
                DeclarationResolver.this.unresolvedTypeDeclarations.putAll((Object)typeDeclarationFacet, unresolvedTypes);
            }
            return eObject;
        }

        @Override
        public EObject visitTypeDeclarationTuple(RAMLParser.TypeDeclarationTupleContext typeDeclarationTuple) {
            EObject resolved = DeclarationResolver.this.getType(typeDeclarationTuple, this.scope);
            this.scope.setValue(resolved, typeDeclarationTuple.getStart());
            return resolved;
        }

        @Override
        public EObject visitTypeDeclarationMap(RAMLParser.TypeDeclarationMapContext typeDeclarationMap) {
            EObject resolved = DeclarationResolver.this.getType(typeDeclarationMap, this.scope);
            this.scope.setValue(resolved, typeDeclarationMap.getStart());
            return resolved;
        }

        @Override
        public Object visitSecuritySchemesFacet(RAMLParser.SecuritySchemesFacetContext ctx) {
            return this.withinScope(this.scope.with((EStructuralFeature)SecurityPackage.Literals.SECURITY_SCHEME_CONTAINER__SECURITY_SCHEMES), securitySchemesScope -> super.visitSecuritySchemesFacet(ctx));
        }

        @Override
        public Object visitSecuritySchemeFacet(RAMLParser.SecuritySchemeFacetContext securitySchemeFacet) {
            SecurityScheme securityScheme = (SecurityScheme)this.create(SecurityPackage.Literals.SECURITY_SCHEME, securitySchemeFacet);
            String name = securitySchemeFacet.name.getText();
            securityScheme.setName(name);
            this.scope.setValue(securityScheme, securitySchemeFacet.getStart());
            return securityScheme;
        }

        private List<EObject> getUnresolvedTypes(EObject type) {
            return this.unresolvedTypesCollector.doSwitch(type);
        }
    }
}

