/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.persistence.constructor;

import io.vrap.rmf.raml.model.modules.Api;
import io.vrap.rmf.raml.model.modules.ApiExtension;
import io.vrap.rmf.raml.model.modules.Extension;
import io.vrap.rmf.raml.model.modules.ModulesPackage;
import io.vrap.rmf.raml.persistence.antlr.RAMLParser;
import io.vrap.rmf.raml.persistence.constructor.ApiConstructor;
import io.vrap.rmf.raml.persistence.constructor.DeclarationResolver;
import io.vrap.rmf.raml.persistence.constructor.Scope;
import java.util.Collection;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class ExtensionConstructor
extends ApiConstructor {
    @Override
    public EObject construct(RAMLParser parser, Scope scope) {
        DeclarationResolver declarationResolver = new DeclarationResolver();
        RAMLParser.ExtensionContext extensionContext = parser.extension();
        declarationResolver.resolve(extensionContext, scope);
        Extension extension = (Extension)this.withinScope(scope, (T s) -> this.visitExtension(extensionContext));
        return extension;
    }

    @Override
    public Object visitExtension(RAMLParser.ExtensionContext ctx) {
        EObject rootObject = (EObject)this.scope.getResource().getContents().get(0);
        return this.withinScope(this.scope.with(rootObject), (T rootScope) -> {
            if (ctx.extendsFacet().isEmpty()) {
                this.scope.addError("Required 'extends' facet missing", new Object[0]);
            } else {
                ctx.extendsFacet().forEach(this::visitExtendsFacet);
            }
            Predicate<RAMLParser.TypeContainerFacetsContext> isSecuritySchemesFacet = typeContainerFacets -> typeContainerFacets.securitySchemesFacet() != null;
            ctx.typeContainerFacets().stream().filter(isSecuritySchemesFacet).forEach(this::visitTypeContainerFacets);
            ctx.typeContainerFacets().stream().filter(isSecuritySchemesFacet.negate()).forEach(this::visitTypeContainerFacets);
            ctx.apiFacets().forEach(this::visitApiFacets);
            return rootObject;
        });
    }

    @Override
    public Object visitExtendsFacet(RAMLParser.ExtendsFacetContext extendsFacet) {
        String extendsUri = extendsFacet.uri.getText();
        Resource extendsResource = this.scope.getResource(extendsUri);
        EList errors = extendsResource.getErrors();
        if (errors.isEmpty()) {
            EList contents = extendsResource.getContents();
            if (contents.size() != 1) {
                this.scope.addErrorWithLocation("Extended api definition is invalid", extendsFacet.getStart(), new Object[0]);
            } else {
                EObject extendsEObject = (EObject)contents.get(0);
                if (extendsEObject instanceof Api || extendsEObject instanceof ApiExtension) {
                    this.scope.setValue((EStructuralFeature)ModulesPackage.Literals.API_EXTENSION__EXTENDS, extendsEObject, extendsFacet.uri.getStart());
                } else {
                    this.scope.addErrorWithLocation("Extended api definition has invalid type ''{0}''", extendsFacet.getStart(), extendsEObject.eClass().getName());
                }
            }
        } else {
            this.scope.getResource().getErrors().addAll((Collection)errors);
        }
        return super.visitExtendsFacet(extendsFacet);
    }
}

