/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.persistence.constructor;

import io.vrap.rmf.raml.model.types.AnyType;
import io.vrap.rmf.raml.model.types.BuiltinType;
import io.vrap.rmf.raml.model.types.TypesPackage;
import io.vrap.rmf.raml.persistence.antlr.RAMLParser;
import io.vrap.rmf.raml.persistence.constructor.BaseConstructor;
import io.vrap.rmf.raml.persistence.constructor.DeclarationResolver;
import io.vrap.rmf.raml.persistence.constructor.Scope;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class TypeDeclarationFragmentConstructor
extends BaseConstructor {
    private final EReference typeContainer;

    public TypeDeclarationFragmentConstructor(EReference typeContainer) {
        this.typeContainer = typeContainer;
    }

    @Override
    public EObject construct(RAMLParser parser, Scope scope) {
        DeclarationResolver declarationResolver = new DeclarationResolver();
        RAMLParser.TypeDeclarationFragmentContext typeDeclarationFragmentContext = parser.typeDeclarationFragment();
        declarationResolver.resolve(typeDeclarationFragmentContext, scope.with((EStructuralFeature)this.typeContainer));
        return (EObject)this.withinScope(scope.with((EStructuralFeature)this.typeContainer), (T typeScope) -> this.visitTypeDeclarationFragment(typeDeclarationFragmentContext));
    }

    @Override
    public Object visitTypeDeclarationFragment(RAMLParser.TypeDeclarationFragmentContext typeDeclarationFragment) {
        AnyType superType;
        if (typeDeclarationFragment.typeFacet().size() > 0) {
            RAMLParser.TypeFacetContext typeFacet = typeDeclarationFragment.typeFacet().get(0);
            superType = (EObject)this.visitTypeFacet(typeFacet);
        } else {
            superType = typeDeclarationFragment.propertiesFacet().size() > 0 ? BuiltinType.OBJECT.getType(this.scope.getResourceSet()) : BuiltinType.STRING.getType(this.scope.getResourceSet());
        }
        EClass eClass = superType.eClass();
        Object declaredType = this.create(eClass, typeDeclarationFragment);
        this.scope.getResource().getContents().add(declaredType);
        this.withinScope(this.scope.with((EObject)declaredType), (T typeScope) -> {
            if (TypesPackage.Literals.ANY_TYPE.isSuperTypeOf(eClass)) {
                EStructuralFeature typeReference = eClass.getEStructuralFeature("type");
                typeScope.setValue(typeReference, superType, typeDeclarationFragment.getStart());
            }
            typeDeclarationFragment.annotationFacet().forEach(this::visitAnnotationFacet);
            typeDeclarationFragment.attributeFacet().forEach(this::visitAttributeFacet);
            typeDeclarationFragment.descriptionFacet().forEach(this::visitDescriptionFacet);
            typeDeclarationFragment.displayNameFacet().forEach(this::visitDisplayNameFacet);
            typeDeclarationFragment.propertiesFacet().forEach(this::visitPropertiesFacet);
            typeDeclarationFragment.defaultFacet().forEach(this::visitDefaultFacet);
            typeDeclarationFragment.exampleFacet().forEach(this::visitExampleFacet);
            typeDeclarationFragment.examplesFacet().forEach(this::visitExamplesFacet);
            typeDeclarationFragment.enumFacet().forEach(this::visitEnumFacet);
            typeDeclarationFragment.itemsFacet().forEach(this::visitItemsFacet);
            return declaredType;
        });
        return declaredType;
    }
}

