/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.validation;

import io.vrap.rmf.raml.model.types.ProtocolsFacet;
import io.vrap.rmf.raml.validation.DiagnosticsCreator;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.Diagnostic;

class ProtocolFacetsValidator
implements DiagnosticsCreator {
    private static final Predicate<String> VALID_PROTOCOL = Pattern.compile("(http)|(https)|(HTTP)|(HTTPS)").asPredicate();

    ProtocolFacetsValidator() {
    }

    public List<Diagnostic> validate(ProtocolsFacet protocolsFacet) {
        List invalidProtocols = protocolsFacet.getProtocols().stream().filter(VALID_PROTOCOL.negate()).collect(Collectors.toList());
        return invalidProtocols.stream().map(invalidProtocol -> this.error(protocolsFacet, "Invalid protocol ''{0}''", invalidProtocol)).collect(Collectors.toList());
    }
}

