/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.validation;

import io.vrap.rmf.raml.model.resources.MethodBase;
import io.vrap.rmf.raml.model.resources.Resource;
import io.vrap.rmf.raml.model.resources.util.ResourcesSwitch;
import io.vrap.rmf.raml.validation.AbstractRamlValidator;
import io.vrap.rmf.raml.validation.ProtocolFacetsValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

class ResourcesValidator
extends AbstractRamlValidator {
    private final ProtocolFacetsValidator protocolFacetsValidator = new ProtocolFacetsValidator();
    private final ResourcesValidatingVisitor visitor = new ResourcesValidatingVisitor();

    ResourcesValidator() {
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ArrayList validationErrors = new ArrayList();
        validationErrors.addAll((Collection)this.visitor.doSwitch(eObject));
        validationErrors.forEach(arg_0 -> ((DiagnosticChain)diagnostics).add(arg_0));
        return validationErrors.isEmpty();
    }

    private class ResourcesValidatingVisitor
    extends ResourcesSwitch<List<Diagnostic>> {
        private ResourcesValidatingVisitor() {
        }

        @Override
        public List<Diagnostic> defaultCase(EObject object) {
            return Collections.emptyList();
        }

        @Override
        public List<Diagnostic> caseMethodBase(MethodBase methodBase) {
            return ResourcesValidator.this.protocolFacetsValidator.validate(methodBase);
        }

        @Override
        public List<Diagnostic> caseResource(Resource resource) {
            List<Diagnostic> validationErrors = this.noOptionalMethodsAllowed(resource);
            return validationErrors;
        }

        private List<Diagnostic> noOptionalMethodsAllowed(Resource resource) {
            List optionalMethods = resource.getMethods().stream().filter(method -> !method.isRequired()).collect(Collectors.toList());
            return optionalMethods.stream().map(method -> ResourcesValidator.this.error(resource, "Optional method ''{0}'' not allowed", new Object[]{method.getMethod()})).collect(Collectors.toList());
        }
    }
}

