/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.model.resources;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HttpMethod implements Enumerator
{
    GET(0, "get", "get"),
    PATCH(0, "patch", "patch"),
    PUT(0, "put", "put"),
    POST(0, "post", "post"),
    DELETE(0, "delete", "delete"),
    HEAD(0, "head", "head"),
    OPTIONS(0, "options", "options");

    public static final int GET_VALUE = 0;
    public static final int PATCH_VALUE = 0;
    public static final int PUT_VALUE = 0;
    public static final int POST_VALUE = 0;
    public static final int DELETE_VALUE = 0;
    public static final int HEAD_VALUE = 0;
    public static final int OPTIONS_VALUE = 0;
    private static final HttpMethod[] VALUES_ARRAY;
    public static final List<HttpMethod> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static HttpMethod get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            HttpMethod result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static HttpMethod getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            HttpMethod result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static HttpMethod get(int value) {
        switch (value) {
            case 0: {
                return GET;
            }
        }
        return null;
    }

    private HttpMethod(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new HttpMethod[]{GET, PATCH, PUT, POST, DELETE, HEAD, OPTIONS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

