/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.model.resources.impl;

import com.damnhandy.uri.template.UriTemplate;
import io.vrap.rmf.raml.model.resources.AnnotatedUriTemplate;
import io.vrap.rmf.raml.model.resources.HttpMethod;
import io.vrap.rmf.raml.model.resources.Method;
import io.vrap.rmf.raml.model.resources.Parameter;
import io.vrap.rmf.raml.model.resources.ParameterizedApplication;
import io.vrap.rmf.raml.model.resources.Resource;
import io.vrap.rmf.raml.model.resources.ResourceType;
import io.vrap.rmf.raml.model.resources.ResourceTypeApplication;
import io.vrap.rmf.raml.model.resources.ResourcesFactory;
import io.vrap.rmf.raml.model.resources.ResourcesPackage;
import io.vrap.rmf.raml.model.resources.Trait;
import io.vrap.rmf.raml.model.resources.TraitApplication;
import io.vrap.rmf.raml.model.resources.UriParameter;
import io.vrap.rmf.raml.model.resources.impl.AnnotatedUriTemplateImpl;
import io.vrap.rmf.raml.model.resources.impl.MethodImpl;
import io.vrap.rmf.raml.model.resources.impl.ParameterImpl;
import io.vrap.rmf.raml.model.resources.impl.ParameterizedApplicationImpl;
import io.vrap.rmf.raml.model.resources.impl.ResourceImpl;
import io.vrap.rmf.raml.model.resources.impl.ResourceTypeApplicationImpl;
import io.vrap.rmf.raml.model.resources.impl.ResourceTypeImpl;
import io.vrap.rmf.raml.model.resources.impl.TraitApplicationImpl;
import io.vrap.rmf.raml.model.resources.impl.TraitImpl;
import io.vrap.rmf.raml.model.resources.impl.UriParameterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class ResourcesFactoryImpl
extends EFactoryImpl
implements ResourcesFactory {
    public static ResourcesFactory init() {
        try {
            ResourcesFactory theResourcesFactory = (ResourcesFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.vrap.io/raml/resources");
            if (theResourcesFactory != null) {
                return theResourcesFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ResourcesFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createAnnotatedUriTemplate();
            }
            case 1: {
                return this.createUriParameter();
            }
            case 4: {
                return this.createResource();
            }
            case 5: {
                return this.createResourceType();
            }
            case 8: {
                return this.createMethod();
            }
            case 9: {
                return this.createTrait();
            }
            case 10: {
                return this.createParameterizedApplication();
            }
            case 11: {
                return this.createResourceTypeApplication();
            }
            case 12: {
                return this.createTraitApplication();
            }
            case 13: {
                return this.createParameter();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 14: {
                return this.createHttpMethodFromString(eDataType, initialValue);
            }
            case 15: {
                return this.createUriTemplateFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 14: {
                return this.convertHttpMethodToString(eDataType, instanceValue);
            }
            case 15: {
                return this.convertUriTemplateToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public AnnotatedUriTemplate createAnnotatedUriTemplate() {
        AnnotatedUriTemplateImpl annotatedUriTemplate = new AnnotatedUriTemplateImpl();
        return annotatedUriTemplate;
    }

    @Override
    public UriParameter createUriParameter() {
        UriParameterImpl uriParameter = new UriParameterImpl();
        return uriParameter;
    }

    @Override
    public Resource createResource() {
        ResourceImpl resource = new ResourceImpl();
        return resource;
    }

    @Override
    public ResourceType createResourceType() {
        ResourceTypeImpl resourceType = new ResourceTypeImpl();
        return resourceType;
    }

    @Override
    public Method createMethod() {
        MethodImpl method = new MethodImpl();
        return method;
    }

    @Override
    public Trait createTrait() {
        TraitImpl trait = new TraitImpl();
        return trait;
    }

    @Override
    public ParameterizedApplication createParameterizedApplication() {
        ParameterizedApplicationImpl parameterizedApplication = new ParameterizedApplicationImpl();
        return parameterizedApplication;
    }

    @Override
    public ResourceTypeApplication createResourceTypeApplication() {
        ResourceTypeApplicationImpl resourceTypeApplication = new ResourceTypeApplicationImpl();
        return resourceTypeApplication;
    }

    @Override
    public TraitApplication createTraitApplication() {
        TraitApplicationImpl traitApplication = new TraitApplicationImpl();
        return traitApplication;
    }

    @Override
    public Parameter createParameter() {
        ParameterImpl parameter = new ParameterImpl();
        return parameter;
    }

    public HttpMethod createHttpMethodFromString(EDataType eDataType, String initialValue) {
        HttpMethod result = HttpMethod.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertHttpMethodToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public UriTemplate createUriTemplate(String it) {
        return UriTemplate.fromTemplate((String)it);
    }

    public UriTemplate createUriTemplateFromString(EDataType eDataType, String initialValue) {
        return this.createUriTemplate(initialValue);
    }

    public String convertUriTemplateToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public ResourcesPackage getResourcesPackage() {
        return (ResourcesPackage)this.getEPackage();
    }

    @Deprecated
    public static ResourcesPackage getPackage() {
        return ResourcesPackage.eINSTANCE;
    }
}

