/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.model.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SecuritySchemeType implements Enumerator
{
    OAUTH_10(0, "OAuth_10", "OAuth 1.0"),
    OAUTH_20(0, "OAuth_20", "OAuth 2.0"),
    BASIC_AUTHENTICATION(0, "Basic_Authentication", "Basic Authentication"),
    DIGEST_AUTHENTICATION(0, "Digest_Authentication", "Digest Authentication"),
    PASS_THROUGH(0, "Pass_Through", "Pass Through"),
    XOTHER(0, "x_Other", "x-other");

    public static final int OAUTH_10_VALUE = 0;
    public static final int OAUTH_20_VALUE = 0;
    public static final int BASIC_AUTHENTICATION_VALUE = 0;
    public static final int DIGEST_AUTHENTICATION_VALUE = 0;
    public static final int PASS_THROUGH_VALUE = 0;
    public static final int XOTHER_VALUE = 0;
    private static final SecuritySchemeType[] VALUES_ARRAY;
    public static final List<SecuritySchemeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static SecuritySchemeType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SecuritySchemeType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static SecuritySchemeType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SecuritySchemeType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static SecuritySchemeType get(int value) {
        switch (value) {
            case 0: {
                return OAUTH_10;
            }
        }
        return null;
    }

    private SecuritySchemeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new SecuritySchemeType[]{OAUTH_10, OAUTH_20, BASIC_AUTHENTICATION, DIGEST_AUTHENTICATION, PASS_THROUGH, XOTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

