/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.model.security.impl;

import io.vrap.rmf.raml.model.security.OAuth10Settings;
import io.vrap.rmf.raml.model.security.OAuth20Settings;
import io.vrap.rmf.raml.model.security.SecuredBy;
import io.vrap.rmf.raml.model.security.SecurityFactory;
import io.vrap.rmf.raml.model.security.SecurityPackage;
import io.vrap.rmf.raml.model.security.SecurityScheme;
import io.vrap.rmf.raml.model.security.SecuritySchemeDescription;
import io.vrap.rmf.raml.model.security.SecuritySchemeType;
import io.vrap.rmf.raml.model.security.impl.OAuth10SettingsImpl;
import io.vrap.rmf.raml.model.security.impl.OAuth20SettingsImpl;
import io.vrap.rmf.raml.model.security.impl.SecuredByImpl;
import io.vrap.rmf.raml.model.security.impl.SecuritySchemeDescriptionImpl;
import io.vrap.rmf.raml.model.security.impl.SecuritySchemeImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class SecurityFactoryImpl
extends EFactoryImpl
implements SecurityFactory {
    public static SecurityFactory init() {
        try {
            SecurityFactory theSecurityFactory = (SecurityFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.vrap.io/raml/security");
            if (theSecurityFactory != null) {
                return theSecurityFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new SecurityFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 2: {
                return this.createSecurityScheme();
            }
            case 3: {
                return this.createSecuritySchemeDescription();
            }
            case 5: {
                return this.createOAuth10Settings();
            }
            case 6: {
                return this.createOAuth20Settings();
            }
            case 7: {
                return this.createSecuredBy();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.createSecuritySchemeTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.convertSecuritySchemeTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public SecurityScheme createSecurityScheme() {
        SecuritySchemeImpl securityScheme = new SecuritySchemeImpl();
        return securityScheme;
    }

    @Override
    public SecuritySchemeDescription createSecuritySchemeDescription() {
        SecuritySchemeDescriptionImpl securitySchemeDescription = new SecuritySchemeDescriptionImpl();
        return securitySchemeDescription;
    }

    @Override
    public OAuth10Settings createOAuth10Settings() {
        OAuth10SettingsImpl oAuth10Settings = new OAuth10SettingsImpl();
        return oAuth10Settings;
    }

    @Override
    public OAuth20Settings createOAuth20Settings() {
        OAuth20SettingsImpl oAuth20Settings = new OAuth20SettingsImpl();
        return oAuth20Settings;
    }

    @Override
    public SecuredBy createSecuredBy() {
        SecuredByImpl securedBy = new SecuredByImpl();
        return securedBy;
    }

    public SecuritySchemeType createSecuritySchemeTypeFromString(EDataType eDataType, String initialValue) {
        SecuritySchemeType result = SecuritySchemeType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSecuritySchemeTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public SecurityPackage getSecurityPackage() {
        return (SecurityPackage)this.getEPackage();
    }

    @Deprecated
    public static SecurityPackage getPackage() {
        return SecurityPackage.eINSTANCE;
    }
}

