/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.model.types;

import io.vrap.rmf.raml.model.types.AnyType;
import io.vrap.rmf.raml.model.types.TypesPackage;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.ResourceSet;

public final class BuiltinType
extends Enum<BuiltinType> {
    public static final /* enum */ BuiltinType ANY = new BuiltinType("any", TypesPackage.Literals.ANY_TYPE, TypesPackage.Literals.ANY_ANNOTATION_TYPE);
    public static final /* enum */ BuiltinType TIME_ONLY = new BuiltinType("time-only", TypesPackage.Literals.TIME_ONLY_TYPE, TypesPackage.Literals.TIME_ONLY_ANNOTATION_TYPE);
    public static final /* enum */ BuiltinType DATE_TIME = new BuiltinType("datetime", TypesPackage.Literals.DATE_TIME_TYPE, TypesPackage.Literals.DATE_TIME_ANNOTATION_TYPE);
    public static final /* enum */ BuiltinType DATE_TIME_ONLY = new BuiltinType("datetime-only", TypesPackage.Literals.DATE_TIME_ONLY_TYPE, TypesPackage.Literals.DATE_TIME_ONLY_ANNOTATION_TYPE);
    public static final /* enum */ BuiltinType DATE_ONLY = new BuiltinType("date-only", TypesPackage.Literals.DATE_ONLY_TYPE, TypesPackage.Literals.DATE_ONLY_ANNOTATION_TYPE);
    public static final /* enum */ BuiltinType NUMBER = new BuiltinType("number", TypesPackage.Literals.NUMBER_TYPE, TypesPackage.Literals.NUMBER_ANNOTATION_TYPE);
    public static final /* enum */ BuiltinType INTEGER = new BuiltinType("integer", TypesPackage.Literals.INTEGER_TYPE, TypesPackage.Literals.INTEGER_ANNOTATION_TYPE);
    public static final /* enum */ BuiltinType BOOLEAN = new BuiltinType("boolean", TypesPackage.Literals.BOOLEAN_TYPE, TypesPackage.Literals.BOOLEAN_ANNOTATION_TYPE);
    public static final /* enum */ BuiltinType STRING = new BuiltinType("string", TypesPackage.Literals.STRING_TYPE, TypesPackage.Literals.STRING_ANNOTATION_TYPE);
    public static final /* enum */ BuiltinType NIL = new BuiltinType("nil", TypesPackage.Literals.NIL_TYPE, TypesPackage.Literals.NIL_ANNOTATION_TYPE);
    public static final /* enum */ BuiltinType FILE = new BuiltinType("file", TypesPackage.Literals.FILE_TYPE, TypesPackage.Literals.FILE_ANNOTATION_TYPE);
    public static final /* enum */ BuiltinType ARRAY = new BuiltinType("array", TypesPackage.Literals.ARRAY_TYPE, TypesPackage.Literals.ARRAY_ANNOTATION_TYPE);
    public static final /* enum */ BuiltinType OBJECT = new BuiltinType("object", TypesPackage.Literals.OBJECT_TYPE, TypesPackage.Literals.OBJECT_ANNOTATION_TYPE);
    private final EClass annotationTypeDeclarationType;
    private final EClass typeDeclarationType;
    private final String name;
    public static final URI RESOURCE_URI;
    private static final /* synthetic */ BuiltinType[] $VALUES;

    public static BuiltinType[] values() {
        return (BuiltinType[])$VALUES.clone();
    }

    public static BuiltinType valueOf(String name) {
        return Enum.valueOf(BuiltinType.class, name);
    }

    private BuiltinType(String name, EClass typeDeclarationType, EClass annotationTypeDeclarationType) {
        assert (TypesPackage.Literals.ANY_ANNOTATION_TYPE.isSuperTypeOf(annotationTypeDeclarationType));
        this.typeDeclarationType = typeDeclarationType;
        this.annotationTypeDeclarationType = annotationTypeDeclarationType;
        this.name = name;
    }

    public AnyType getType(ResourceSet resourceSet) {
        return (AnyType)resourceSet.getResource(RESOURCE_URI, true).getEObject("/types/" + this.name);
    }

    public EClass getTypeDeclarationType() {
        return this.typeDeclarationType;
    }

    public EClass getAnnotationTypeDeclarationType() {
        return this.annotationTypeDeclarationType;
    }

    public String getName() {
        return this.name;
    }

    public static Optional<BuiltinType> of(String name) {
        return Stream.of(BuiltinType.values()).filter(builtinMetaType -> builtinMetaType.getName().equals(name)).findFirst();
    }

    public static Optional<BuiltinType> of(EClass eClass) {
        return Stream.of(BuiltinType.values()).filter(builtinMetaType -> builtinMetaType.typeDeclarationType == eClass || builtinMetaType.annotationTypeDeclarationType == eClass).findFirst();
    }

    static {
        $VALUES = new BuiltinType[]{ANY, TIME_ONLY, DATE_TIME, DATE_TIME_ONLY, DATE_ONLY, NUMBER, INTEGER, BOOLEAN, STRING, NIL, FILE, ARRAY, OBJECT};
        RESOURCE_URI = URI.createURI((String)"http://raml.org/raml/1.0/builtin-types.raml");
    }
}

