/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.model.util;

import com.damnhandy.uri.template.UriTemplate;
import com.google.common.net.MediaType;
import io.vrap.rmf.raml.model.elements.NamedElement;
import io.vrap.rmf.raml.model.resources.Resource;
import io.vrap.rmf.raml.model.resources.ResourceContainer;
import io.vrap.rmf.raml.model.resources.ResourcesFactory;
import io.vrap.rmf.raml.model.resources.UriParameter;
import io.vrap.rmf.raml.model.responses.Body;
import io.vrap.rmf.raml.model.responses.BodyContainer;
import io.vrap.rmf.raml.model.types.BuiltinType;
import io.vrap.rmf.raml.model.types.ObjectType;
import io.vrap.rmf.raml.model.types.ObjectTypeFacet;
import io.vrap.rmf.raml.model.types.Property;
import io.vrap.rmf.raml.model.types.TypedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;

public class ModelHelper {
    private ModelHelper() {
    }

    public static boolean testPattern(TypedElement typedElement, String value) {
        return typedElement.getPattern().test(value);
    }

    public static UriTemplate fullUri(Resource resource) {
        UriTemplate fullUriTemplate;
        UriTemplate relativeUri = resource.getRelativeUri();
        if (relativeUri == null) {
            fullUriTemplate = null;
        } else {
            Resource resourceParent = resource.getParent();
            UriTemplate fullParentUri = resourceParent != null ? ModelHelper.fullUri(resourceParent) : null;
            StringBuffer stringBuffer = new StringBuffer();
            if (fullParentUri != null && !fullParentUri.getTemplate().equals("/")) {
                stringBuffer.append(fullParentUri.getTemplate());
            }
            stringBuffer.append(relativeUri.getTemplate());
            String fullUri = stringBuffer.toString();
            fullUriTemplate = UriTemplate.fromTemplate((String)fullUri);
        }
        return fullUriTemplate;
    }

    public static List<Resource> allContainedResources(ResourceContainer resourceContainer) {
        ArrayList<Resource> allContainedResources = new ArrayList<Resource>((Collection<Resource>)resourceContainer.getResources());
        allContainedResources.addAll(resourceContainer.getResources().stream().flatMap(r -> ModelHelper.allContainedResources(r).stream()).collect(Collectors.toList()));
        return allContainedResources;
    }

    public static List<UriParameter> fullUriParameters(Resource resource) {
        ArrayList<UriParameter> allUriParameters = new ArrayList<UriParameter>();
        UriTemplate fullUri = resource.getFullUri();
        if (fullUri != null) {
            for (String parameter : fullUri.getVariables()) {
                UriParameter uriParameter = resource.getUriParameter(parameter);
                if (uriParameter == null) {
                    uriParameter = ResourcesFactory.eINSTANCE.createUriParameter();
                    uriParameter.setName(parameter);
                    uriParameter.setType(BuiltinType.STRING.getType(resource.eResource().getResourceSet()));
                }
                allUriParameters.add(uriParameter);
            }
        }
        return allUriParameters;
    }

    public static List<UriParameter> relativeUriParameters(Resource resource) {
        ArrayList<UriParameter> uriParameters = new ArrayList<UriParameter>();
        UriTemplate relativeUri = resource.getRelativeUri();
        if (relativeUri != null) {
            for (String parameter : relativeUri.getVariables()) {
                UriParameter uriParameter = resource.getUriParameter(parameter);
                if (uriParameter == null) {
                    uriParameter = ResourcesFactory.eINSTANCE.createUriParameter();
                    uriParameter.setName(parameter);
                    uriParameter.setType(BuiltinType.STRING.getType(resource.eResource().getResourceSet()));
                }
                uriParameters.add(uriParameter);
            }
        }
        return uriParameters;
    }

    public static String resourcePath(Resource resource) {
        UriTemplate fullUri = resource.getFullUri();
        return fullUri != null ? fullUri.getTemplate() : "";
    }

    public static String resourcePathName(Resource resource) {
        String[] fragments = ModelHelper.resourcePath(resource).split("/");
        LinkedList nonExpressionFragments = Stream.of(fragments).filter(fragment -> !fragment.contains("{")).collect(Collectors.toCollection(LinkedList::new));
        return nonExpressionFragments.isEmpty() ? "" : (String)nonExpressionFragments.getLast();
    }

    public static Body getBody(BodyContainer container, String contentType) {
        MediaType parsedContentType = MediaType.parse((String)contentType);
        return container.getBodies().stream().filter(body -> Optional.ofNullable(body.getContentMediaType()).filter(mediaType -> parsedContentType.is(mediaType)).isPresent()).findFirst().orElse(null);
    }

    public static Map<String, Property> getAllPropertiesAsMap(ObjectTypeFacet objectTypeFacet) {
        Predicate<Property> withoutPattern = p -> p.getPattern() == null;
        if (objectTypeFacet instanceof ObjectType) {
            ObjectType objectType = (ObjectType)objectTypeFacet;
            return ModelHelper.getAllPropertiesAsMapInternal(objectType, withoutPattern);
        }
        return ModelHelper.getPropertiesAsMapInternal(objectTypeFacet, withoutPattern);
    }

    public static EList<MediaType> getMediaTypes(List<String> mediaTypes) {
        List types = mediaTypes.stream().map(MediaType::parse).collect(Collectors.toList());
        return ECollections.toEList(types);
    }

    public static MediaType getMediaType(String mediaType) {
        return MediaType.parse((String)mediaType);
    }

    public static EList<Property> getAllProperties(ObjectType objectType) {
        Collection<Property> values = ModelHelper.getAllPropertiesAsMapInternal(objectType, p -> true).values();
        return ECollections.toEList(values);
    }

    public static EList<Property> getAllPatternProperties(ObjectType objectType) {
        Collection<Property> values = ModelHelper.getAllPropertiesAsMapInternal(objectType, p -> p.getPattern() != null).values();
        return ECollections.toEList(values);
    }

    private static Map<String, Property> getAllPropertiesAsMapInternal(ObjectType objectType, Predicate<Property> filter) {
        LinkedHashMap<String, Property> allPropertiesAsMap = new LinkedHashMap<String, Property>();
        if (objectType.getType() instanceof ObjectType) {
            ObjectType parent = (ObjectType)objectType.getType();
            allPropertiesAsMap.putAll(ModelHelper.getAllPropertiesAsMapInternal(parent, filter));
        }
        allPropertiesAsMap.putAll(ModelHelper.getPropertiesAsMapInternal(objectType, filter));
        return allPropertiesAsMap;
    }

    private static Map<String, Property> getPropertiesAsMapInternal(ObjectTypeFacet objectType, Predicate<Property> filter) {
        LinkedHashMap<String, Property> allPropertiesAsMap = new LinkedHashMap<String, Property>();
        if (objectType != null) {
            Map filteredProperties = objectType.getProperties().stream().filter(filter).collect(Collectors.toMap(NamedElement::getName, Function.identity(), (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            }, LinkedHashMap::new));
            allPropertiesAsMap.putAll(filteredProperties);
        }
        return allPropertiesAsMap;
    }
}

