/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.model.util;

import io.vrap.rmf.nodes.ArrayNode;
import io.vrap.rmf.nodes.BooleanNode;
import io.vrap.rmf.nodes.IntegerNode;
import io.vrap.rmf.nodes.NullNode;
import io.vrap.rmf.nodes.NumberNode;
import io.vrap.rmf.nodes.ObjectNode;
import io.vrap.rmf.nodes.PropertyNode;
import io.vrap.rmf.nodes.StringNode;
import io.vrap.rmf.nodes.util.NodesSwitch;
import io.vrap.rmf.raml.model.types.ArrayInstance;
import io.vrap.rmf.raml.model.types.BooleanInstance;
import io.vrap.rmf.raml.model.types.Instance;
import io.vrap.rmf.raml.model.types.IntegerInstance;
import io.vrap.rmf.raml.model.types.NumberInstance;
import io.vrap.rmf.raml.model.types.ObjectInstance;
import io.vrap.rmf.raml.model.types.PropertyValue;
import io.vrap.rmf.raml.model.types.StringInstance;
import io.vrap.rmf.raml.model.types.TypesFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;

class NodeToInstanceTransformation
extends NodesSwitch<Instance> {
    NodeToInstanceTransformation() {
    }

    public Instance caseStringNode(StringNode stringNode) {
        StringInstance stringInstance = TypesFactory.eINSTANCE.createStringInstance();
        stringInstance.setValue((String)stringNode.getValue());
        return this.copyAdapters((EObject)stringNode, stringInstance);
    }

    public Instance caseBooleanNode(BooleanNode booleanNode) {
        BooleanInstance booleanInstance = TypesFactory.eINSTANCE.createBooleanInstance();
        booleanInstance.setValue((Boolean)booleanNode.getValue());
        return this.copyAdapters((EObject)booleanNode, booleanInstance);
    }

    public Instance caseIntegerNode(IntegerNode integerNode) {
        IntegerInstance integerInstance = TypesFactory.eINSTANCE.createIntegerInstance();
        integerInstance.setValue((BigInteger)integerNode.getValue());
        return this.copyAdapters((EObject)integerNode, integerInstance);
    }

    public Instance caseNullNode(NullNode object) {
        return TypesFactory.eINSTANCE.createNullInstance();
    }

    public Instance caseNumberNode(NumberNode numberNode) {
        NumberInstance numberInstance = TypesFactory.eINSTANCE.createNumberInstance();
        numberInstance.setValue((BigDecimal)numberNode.getValue());
        return this.copyAdapters((EObject)numberNode, numberInstance);
    }

    public Instance caseArrayNode(ArrayNode arrayNode) {
        ArrayInstance arrayInstance = TypesFactory.eINSTANCE.createArrayInstance();
        List elements = arrayNode.getElements().stream().map(arg_0 -> ((NodeToInstanceTransformation)this).doSwitch(arg_0)).collect(Collectors.toList());
        arrayInstance.getValue().addAll(elements);
        return this.copyAdapters((EObject)arrayNode, arrayInstance);
    }

    public Instance caseObjectNode(ObjectNode objectNode) {
        ObjectInstance objectInstance = TypesFactory.eINSTANCE.createObjectInstance();
        List propertyValues = objectNode.getProperties().stream().map(this::transform).collect(Collectors.toList());
        objectInstance.getValue().addAll(propertyValues);
        return this.copyAdapters((EObject)objectNode, objectInstance);
    }

    private PropertyValue transform(PropertyNode propertyNode) {
        PropertyValue propertyValue = TypesFactory.eINSTANCE.createPropertyValue();
        propertyValue.setName(propertyNode.getKey().getValue().toString());
        propertyValue.setValue((Instance)this.doSwitch((EObject)propertyNode.getValue()));
        return this.copyAdapters((EObject)propertyNode, propertyValue);
    }

    private <T extends EObject> T copyAdapters(EObject source, T target) {
        source.eAdapters().forEach(a -> target.eAdapters().add(a));
        return target;
    }
}

