/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.model.values;

import com.google.common.collect.Lists;
import com.hypertino.inflector.English;
import io.vrap.rmf.raml.model.util.StringCaseFormat;
import io.vrap.rmf.raml.persistence.antlr.StringTemplateBaseVisitor;
import io.vrap.rmf.raml.persistence.antlr.StringTemplateLexer;
import io.vrap.rmf.raml.persistence.antlr.StringTemplateParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class StringTemplate {
    private final List<Part> parts;
    private final Set<String> parameters;
    private static final Map<String, Function<String, String>> TRANSFORMATIONS = new HashMap<String, Function<String, String>>();

    private StringTemplate(List<Part> parts) {
        this.parts = parts;
        this.parameters = parts.stream().filter(Expression.class::isInstance).map(Expression.class::cast).map(Expression::getParam).collect(Collectors.toSet());
    }

    public Set<String> getParameters() {
        return this.parameters;
    }

    public String render(Map<String, String> values) {
        return this.parts.stream().map(p -> p.render(values)).collect(Collectors.joining());
    }

    public String toString() {
        return this.parts.stream().map(p -> p.toString()).collect(Collectors.joining());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringTemplate that = (StringTemplate)o;
        return Objects.equals(this.parts, that.parts);
    }

    public int hashCode() {
        return Objects.hash(this.parts);
    }

    public static StringTemplate of(List<Part> parts) {
        return new StringTemplate(parts);
    }

    public static StringTemplate of(String value) {
        if (value.contains("<<")) {
            StringTemplateLexer lexer = new StringTemplateLexer((CharStream)CharStreams.fromString((String)value));
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            StringTemplateParser.StringTemplateContext stringTemplateContext = new StringTemplateParser((TokenStream)tokenStream).stringTemplate();
            List parts = (List)new StringTemplateVisitor().visitStringTemplate(stringTemplateContext);
            return parts.stream().anyMatch(Expression.class::isInstance) ? StringTemplate.of(parts) : null;
        }
        return null;
    }

    static {
        Function<StringCaseFormat, String> toTransformationName = stringCaseFormat -> stringCaseFormat.name().replace("_", "").toLowerCase();
        Stream.of(StringCaseFormat.values()).forEach(stringCaseFormat -> TRANSFORMATIONS.put((String)toTransformationName.apply((StringCaseFormat)stringCaseFormat), (Function<String, String>)stringCaseFormat));
        TRANSFORMATIONS.put("lowercase", String::toLowerCase);
        TRANSFORMATIONS.put("uppercase", String::toUpperCase);
        TRANSFORMATIONS.put("singularize", English::singular);
        TRANSFORMATIONS.put("pluralize", English::plural);
    }

    private static class StringTemplateVisitor
    extends StringTemplateBaseVisitor<List<Part>> {
        private StringTemplateVisitor() {
        }

        protected List<Part> defaultResult() {
            return new ArrayList<Part>();
        }

        protected List<Part> aggregateResult(List<Part> aggregate, List<Part> nextResult) {
            if (aggregate != null) {
                aggregate.addAll(nextResult);
                return aggregate;
            }
            return nextResult;
        }

        @Override
        public List<Part> visitExpression(StringTemplateParser.ExpressionContext ctx) {
            List<String> transformations = ctx.fnApplication().stream().map(c -> c.fn.getText()).collect(Collectors.toList());
            return Lists.newArrayList((Object[])new Part[]{Expression.of(ctx.ID().getText(), transformations)});
        }

        @Override
        public List<Part> visitLiteral(StringTemplateParser.LiteralContext ctx) {
            return Lists.newArrayList((Object[])new Part[]{Literal.of(ctx.getText())});
        }
    }

    private static class Expression
    implements Part {
        private final String param;
        private final List<String> transformations;
        private final Function<String, String> transformation;

        private Expression(String param, List<String> transformations) {
            this.param = param;
            this.transformations = transformations;
            this.transformation = transformations.stream().map(TRANSFORMATIONS::get).collect(Collectors.reducing(Function.identity(), Function::compose));
        }

        public String getParam() {
            return this.param;
        }

        @Override
        public String render(Map<String, String> values) {
            String value = values.get(this.param);
            return value == null ? this.toString() : this.transformation.apply(value);
        }

        public String toString() {
            return this.transformations.isEmpty() ? "<<" + this.param + ">>" : "<<" + this.param + this.transformations.stream().collect(Collectors.joining("|!", "|!", ">>"));
        }

        public static Expression of(String param, List<String> transformations) {
            return new Expression(param, transformations);
        }
    }

    private static class Literal
    implements Part {
        private final String literal;

        private Literal(String literal) {
            this.literal = literal;
        }

        @Override
        public String render(Map<String, String> values) {
            return this.toString();
        }

        public String toString() {
            return this.literal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Literal literal1 = (Literal)o;
            return Objects.equals(this.literal, literal1.literal);
        }

        public int hashCode() {
            return Objects.hash(this.literal);
        }

        public static Literal of(String literal) {
            return new Literal(literal);
        }
    }

    private static interface Part {
        public String render(Map<String, String> var1);
    }
}

