/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.persistence;

import io.vrap.rmf.raml.model.modules.ModulesPackage;
import io.vrap.rmf.raml.model.resources.ResourcesPackage;
import io.vrap.rmf.raml.model.types.TypesPackage;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EClass;

enum RamlFragmentKind {
    API("#%RAML 1.0", ModulesPackage.Literals.API),
    EXTENSION("Extension", ModulesPackage.Literals.EXTENSION),
    LIBRARY("Library", ModulesPackage.Literals.LIBRARY),
    DATA_TYPE("DataType", TypesPackage.Literals.ANY_TYPE),
    ANNOTATION_TYPE_DECLARATION("AnnotationTypeDeclaration", TypesPackage.Literals.ANY_ANNOTATION_TYPE),
    TRAIT("Trait", ResourcesPackage.Literals.TRAIT),
    RESOURCE_TYPE("ResourceType", ResourcesPackage.Literals.RESOURCE_TYPE);

    private static final Pattern HEADER_PATTERN;
    private final String name;
    private final EClass type;

    private RamlFragmentKind(String name, EClass type) {
        this.name = name;
        this.type = type;
    }

    public String getIdentifier() {
        return this.name;
    }

    public EClass getType() {
        return this.type;
    }

    public static Optional<RamlFragmentKind> of(String identifier) {
        return Stream.of(RamlFragmentKind.values()).filter(fragmentKind -> fragmentKind.getIdentifier().equals(identifier)).findFirst();
    }

    public static Optional<RamlFragmentKind> fromHeader(String header) {
        Matcher matcher = HEADER_PATTERN.matcher(header);
        if (matcher.matches()) {
            String name = matcher.start(3) >= 0 ? matcher.group(3) : matcher.group(0);
            return RamlFragmentKind.of(name);
        }
        return Optional.empty();
    }

    static {
        HEADER_PATTERN = Pattern.compile("(#%RAML 1.0)(\\s(\\w+))?");
    }
}

