/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.persistence;

import io.vrap.rmf.raml.model.RamlDiagnostic;
import io.vrap.rmf.raml.model.elements.ElementsPackage;
import io.vrap.rmf.raml.model.modules.ModulesPackage;
import io.vrap.rmf.raml.persistence.RamlFragmentKind;
import io.vrap.rmf.raml.persistence.antlr.ParserErrorCollector;
import io.vrap.rmf.raml.persistence.antlr.RAMLParser;
import io.vrap.rmf.raml.persistence.antlr.RamlNodeTokenSource;
import io.vrap.rmf.raml.persistence.constructor.ApiConstructor;
import io.vrap.rmf.raml.persistence.constructor.BaseConstructor;
import io.vrap.rmf.raml.persistence.constructor.ExtensionConstructor;
import io.vrap.rmf.raml.persistence.constructor.LibraryConstructor;
import io.vrap.rmf.raml.persistence.constructor.Scope;
import io.vrap.rmf.raml.persistence.constructor.TypeDeclarationFragmentConstructor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.Diagnostician;

public class RamlResource
extends ResourceImpl {
    private final Scope resourceScope = Scope.of((Resource)this);

    public RamlResource(URI uri) {
        super(uri);
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        Optional<BaseConstructor> optionalRootConstructor = this.getRootConstructor(bufferedInputStream);
        if (optionalRootConstructor.isPresent()) {
            BaseConstructor rootConstructor = optionalRootConstructor.get();
            RamlNodeTokenSource lexer = new RamlNodeTokenSource(this.uri, this.getURIConverter());
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            RAMLParser parser = new RAMLParser((TokenStream)tokenStream);
            parser.removeErrorListeners();
            ParserErrorCollector errorCollector = new ParserErrorCollector();
            parser.addErrorListener((ANTLRErrorListener)errorCollector);
            try {
                rootConstructor.construct(parser, this.resourceScope);
            }
            catch (Exception e) {
                this.getErrors().addAll(errorCollector.getErrors());
                throw e;
            }
        }
    }

    public void validate() {
        for (EObject eObject : this.getContents()) {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
            if (diagnostic.getSeverity() == 0) continue;
            diagnostic.getChildren().stream().map(RamlDiagnostic::of).forEach(arg_0 -> this.getErrors().add(arg_0));
        }
    }

    public EList<Resource.Diagnostic> validate(Diagnostician diagnostician) {
        for (EObject eObject : this.getContents()) {
            Diagnostic diagnostic = diagnostician.validate(eObject);
            if (diagnostic.getSeverity() == 0) continue;
            diagnostic.getChildren().stream().map(RamlDiagnostic::of).forEach(arg_0 -> this.getErrors().add(arg_0));
        }
        return this.getErrors();
    }

    protected EObject getEObject(List<String> uriFragmentPath) {
        if (uriFragmentPath.size() != 2) {
            throw new AssertionError((Object)("Invalid uri fragment path:" + uriFragmentPath.stream().collect(Collectors.joining("/"))));
        }
        if (uriFragmentPath.size() == 2) {
            EObject rootObject = this.getEObjectForURIFragmentRootSegment("");
            String featureName = uriFragmentPath.get(0);
            EReference feature = (EReference)rootObject.eClass().getEStructuralFeature(featureName);
            EClass eReferenceType = feature.getEReferenceType();
            if (ElementsPackage.Literals.NAMED_ELEMENT.isSuperTypeOf(eReferenceType)) {
                EList children = (EList)rootObject.eGet((EStructuralFeature)feature);
                String name = uriFragmentPath.get(1);
                return children.stream().filter(eObject -> name.equals(eObject.eGet((EStructuralFeature)ElementsPackage.Literals.NAMED_ELEMENT__NAME))).findFirst().orElse(null);
            }
        }
        return null;
    }

    private Optional<BaseConstructor> getRootConstructor(InputStream inputStream) throws IOException {
        inputStream.mark(1024);
        String header = new Scanner(inputStream).useDelimiter("\\n").next();
        inputStream.reset();
        RamlFragmentKind fragmentKind = RamlFragmentKind.fromHeader(header).orElse(null);
        if (fragmentKind == null) {
            this.resourceScope.addError("Unknown fragment kind ''{0}''", header);
            return Optional.empty();
        }
        switch (fragmentKind) {
            case API: {
                return Optional.of(new ApiConstructor());
            }
            case EXTENSION: {
                return Optional.of(new ExtensionConstructor());
            }
            case LIBRARY: {
                return Optional.of(new LibraryConstructor());
            }
            case DATA_TYPE: {
                return Optional.of(new TypeDeclarationFragmentConstructor(ModulesPackage.Literals.TYPE_CONTAINER__TYPES));
            }
            case ANNOTATION_TYPE_DECLARATION: {
                return Optional.of(new TypeDeclarationFragmentConstructor(ModulesPackage.Literals.TYPE_CONTAINER__ANNOTATION_TYPES));
            }
        }
        this.resourceScope.addError("Not yet implemented fragment kind ''{0}''", new Object[]{fragmentKind});
        return Optional.empty();
    }
}

