/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.persistence;

import io.vrap.rmf.raml.model.types.BuiltinType;
import io.vrap.rmf.raml.persistence.ContentNegotiationURIHandler;
import io.vrap.rmf.raml.persistence.RamlResource;
import io.vrap.rmf.raml.validation.RamlValidationSetup;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ArchiveURIHandlerImpl;
import org.eclipse.emf.ecore.resource.impl.EFSURIHandlerImpl;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.FileURIHandlerImpl;
import org.eclipse.emf.ecore.resource.impl.PlatformResourceURIHandlerImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;

public class RamlResourceSet
extends ResourceSetImpl {
    private static final List<String> ACCEPTED_MIME_TYPES = Arrays.asList("application/raml+yaml", "application/yaml", "application/json");
    private static final String ACCEPT_HEADER_VALUE = ACCEPTED_MIME_TYPES.stream().collect(Collectors.joining(", "));

    public static void setup() {
        RamlValidationSetup.setup();
    }

    public RamlResourceSet() {
        List<URIHandler> uriHandlers = Arrays.asList(new URIHandler[]{new PlatformResourceURIHandlerImpl(), new FileURIHandlerImpl(), new EFSURIHandlerImpl(), new ArchiveURIHandlerImpl(), new ContentNegotiationURIHandler(ACCEPT_HEADER_VALUE)});
        ExtensibleURIConverterImpl uriConverter = new ExtensibleURIConverterImpl(uriHandlers, (Collection)ContentHandler.Registry.INSTANCE.contentHandlers());
        this.setURIConverter((URIConverter)uriConverter);
        Resource.Factory.Registry resourceFactoryRegistry = this.getResourceFactoryRegistry();
        RamlResourceFactory resourceFactory = new RamlResourceFactory();
        resourceFactoryRegistry.getExtensionToFactoryMap().put("raml", resourceFactory);
        resourceFactoryRegistry.getProtocolToFactoryMap().put("http", resourceFactory);
        Map contentTypeToFactoryMap = resourceFactoryRegistry.getContentTypeToFactoryMap();
        for (String contentType : ACCEPTED_MIME_TYPES) {
            contentTypeToFactoryMap.put(contentType, resourceFactory);
        }
        this.addBuiltinTypes();
    }

    private void addBuiltinTypes() {
        URL url = RamlResource.class.getResource("/builtin-types.raml");
        URI uri = URI.createURI((String)url.toString());
        this.getURIConverter().getURIMap().put(BuiltinType.RESOURCE_URI, uri);
    }

    public List<Resource.Diagnostic> validate() {
        this.getResources().stream().filter(RamlResource.class::isInstance).map(RamlResource.class::cast).forEach(RamlResource::validate);
        List<Resource.Diagnostic> errors = this.getResources().stream().flatMap(r -> r.getErrors().stream()).collect(Collectors.toList());
        return errors;
    }

    public List<Resource.Diagnostic> validate(Diagnostician diagnostician) {
        this.getResources().stream().filter(RamlResource.class::isInstance).map(RamlResource.class::cast).forEach(ramlResource -> ramlResource.validate(diagnostician != null ? diagnostician : Diagnostician.INSTANCE));
        List<Resource.Diagnostic> errors = this.getResources().stream().flatMap(r -> r.getErrors().stream()).collect(Collectors.toList());
        return errors;
    }

    static {
        RamlResourceSet.setup();
    }

    private static class RamlResourceFactory
    extends ResourceFactoryImpl {
        private RamlResourceFactory() {
        }

        public Resource createResource(URI uri) {
            return new RamlResource(uri);
        }
    }
}

