/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.persistence.constructor;

import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import io.vrap.rmf.raml.model.modules.Api;
import io.vrap.rmf.raml.model.modules.Document;
import io.vrap.rmf.raml.model.modules.ModulesPackage;
import io.vrap.rmf.raml.model.resources.AnnotatedUriTemplate;
import io.vrap.rmf.raml.model.resources.Resource;
import io.vrap.rmf.raml.model.resources.ResourcesFactory;
import io.vrap.rmf.raml.model.resources.ResourcesPackage;
import io.vrap.rmf.raml.persistence.antlr.RAMLParser;
import io.vrap.rmf.raml.persistence.constructor.BaseConstructor;
import io.vrap.rmf.raml.persistence.constructor.DeclarationResolver;
import io.vrap.rmf.raml.persistence.constructor.Scope;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ApiConstructor
extends BaseConstructor {
    @Override
    public EObject construct(RAMLParser parser, Scope scope) {
        DeclarationResolver declarationResolver = new DeclarationResolver();
        RAMLParser.ApiContext apiContext = parser.api();
        declarationResolver.resolve(apiContext, scope);
        Api api = (Api)this.withinScope(scope, (T s) -> this.visitApi(apiContext));
        return api;
    }

    @Override
    public Object visitApi(RAMLParser.ApiContext ctx) {
        EObject rootObject = (EObject)this.scope.getResource().getContents().get(0);
        return this.withinScope(this.scope.with(rootObject), (T rootScope) -> {
            ctx.typeContainerFacets().forEach(this::visitTypeContainerFacets);
            ctx.apiFacets().forEach(this::visitApiFacets);
            return rootObject;
        });
    }

    @Override
    public Object visitDocumentationFacet(RAMLParser.DocumentationFacetContext documentationFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)ModulesPackage.Literals.API_BASE__DOCUMENTATION), (T documentationScope) -> documentationFacet.document().stream().map(this::visitDocument).collect(Collectors.toList()));
    }

    @Override
    public Object visitDocument(RAMLParser.DocumentContext ctx) {
        Document document = (Document)this.create(ModulesPackage.Literals.DOCUMENT, ctx);
        this.scope.setValue(document, ctx.getStart());
        return this.withinScope(this.scope.with(document), (T documentScope) -> {
            ctx.attributeFacet().forEach(this::visitAttributeFacet);
            return document;
        });
    }

    @Override
    public Object visitBaseUriFacet(RAMLParser.BaseUriFacetContext ctx) {
        String baseUriText = ctx.baseUri.id(0).getText();
        AnnotatedUriTemplate annotatedUriTemplate = (AnnotatedUriTemplate)this.create(ResourcesPackage.Literals.ANNOTATED_URI_TEMPLATE, ctx);
        try {
            UriTemplate uriTemplate = (UriTemplate)ResourcesFactory.eINSTANCE.createFromString(ResourcesPackage.Literals.URI_TEMPLATE, baseUriText);
            annotatedUriTemplate.setValue(uriTemplate);
            this.scope.with((EStructuralFeature)ModulesPackage.Literals.API_BASE__BASE_URI).setValue(annotatedUriTemplate, ctx.getStart());
        }
        catch (MalformedUriTemplateException uriTemplateException) {
            this.scope.addErrorWithLocation(uriTemplateException.getMessage(), ctx.getStart(), new Object[0]);
            return null;
        }
        return this.withinScope(this.scope.with(annotatedUriTemplate), (T annotatedUriTemplateScope) -> {
            ctx.baseUri.annotationFacet().forEach(this::visitAnnotationFacet);
            return annotatedUriTemplate;
        });
    }

    @Override
    public Object visitBaseUriParametersFacet(RAMLParser.BaseUriParametersFacetContext baseUriParametersFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)ModulesPackage.Literals.API_BASE__BASE_URI_PARAMETERS), (T baseUriParametersScope) -> {
            List baseUriParameters = baseUriParametersFacet.uriParameterFacets.stream().map(this::visitTypedElementFacet).collect(Collectors.toList());
            this.scope.setValue(baseUriParameters, baseUriParametersFacet.getStart());
            return baseUriParameters;
        });
    }

    @Override
    public Object visitResourceFacet(RAMLParser.ResourceFacetContext resourceFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)ResourcesPackage.Literals.RESOURCE_CONTAINER__RESOURCES), (T resourcesScope) -> {
            Resource resource = (Resource)this.create(ResourcesPackage.Literals.RESOURCE, resourceFacet);
            resourcesScope.setValue(resource, resourceFacet.getStart());
            UriTemplate relativeUri = (UriTemplate)ResourcesFactory.eINSTANCE.createFromString(ResourcesPackage.Literals.URI_TEMPLATE, resourceFacet.relativeUri.getText());
            resource.setRelativeUri(relativeUri);
            return (Resource)this.withinScope(resourcesScope.with(resource), (T resourceScope) -> {
                resourceFacet.resourceBaseFacet().forEach(this::visitResourceBaseFacet);
                resourceFacet.resourceFacet().forEach(this::visitResourceFacet);
                return resource;
            });
        });
    }

    @Override
    public Object visitUriParametersFacet(RAMLParser.UriParametersFacetContext uriParametersFacet) {
        return this.withinScope(this.scope.with((EStructuralFeature)ResourcesPackage.Literals.RESOURCE_BASE__URI_PARAMETERS), (T uriParametersScope) -> {
            EList uriParameters = ECollections.asEList(uriParametersFacet.uriParameterFacets.stream().map(this::visitTypedElementFacet).collect(Collectors.toList()));
            this.scope.setValue(uriParameters, uriParametersFacet.getStart());
            return uriParameters;
        });
    }
}

