/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.persistence.constructor;

import io.vrap.rmf.raml.model.types.Annotation;
import io.vrap.rmf.raml.model.types.AnyAnnotationType;
import io.vrap.rmf.raml.model.types.ArrayInstance;
import io.vrap.rmf.raml.model.types.BooleanInstance;
import io.vrap.rmf.raml.model.types.Instance;
import io.vrap.rmf.raml.model.types.IntegerInstance;
import io.vrap.rmf.raml.model.types.NumberInstance;
import io.vrap.rmf.raml.model.types.ObjectInstance;
import io.vrap.rmf.raml.model.types.PropertyValue;
import io.vrap.rmf.raml.model.types.StringInstance;
import io.vrap.rmf.raml.model.types.TypesPackage;
import io.vrap.rmf.raml.persistence.antlr.RAMLParser;
import io.vrap.rmf.raml.persistence.constructor.AbstractScopedVisitor;
import io.vrap.rmf.raml.persistence.constructor.Scope;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.emf.ecore.EStructuralFeature;

public class InstanceConstructor
extends AbstractScopedVisitor<Instance> {
    public Instance construct(RAMLParser parser, Scope scope) {
        return (Instance)this.withinScope(scope, (T s) -> (Instance)this.visitInstance(parser.instance()));
    }

    @Override
    public Instance visitSimpleInstance(RAMLParser.SimpleInstanceContext ctx) {
        Instance instance = (Instance)super.visitSimpleInstance(ctx);
        this.scope.setValue(instance, ctx.getStart());
        return instance;
    }

    @Override
    public Instance visitAnnotatedSimpleInstance(RAMLParser.AnnotatedSimpleInstanceContext ctx) {
        Instance instance = (Instance)super.visitAnnotatedSimpleInstance(ctx);
        this.scope.setValue(instance, ctx.getStart());
        return instance;
    }

    @Override
    public Instance visitAnnotatedObjectInstance(RAMLParser.AnnotatedObjectInstanceContext ctx) {
        ObjectInstance objectInstance = (ObjectInstance)this.visitObjectInstance(ctx.objectInstance(0));
        this.scope.setValue(objectInstance, ctx.getStart());
        return (Instance)this.withinScope(this.scope.with(objectInstance), (T objectInstanceScope) -> {
            ctx.annotationFacet().forEach(this::visitAnnotationFacet);
            return objectInstance;
        });
    }

    @Override
    public Instance visitAnnotatedArrayInstance(RAMLParser.AnnotatedArrayInstanceContext ctx) {
        ArrayInstance arrayInstance = (ArrayInstance)this.visitArrayInstance(ctx.arrayInstance(0));
        this.scope.setValue(arrayInstance, ctx.getStart());
        return (Instance)this.withinScope(this.scope.with(arrayInstance), (T arrayInstanceScope) -> {
            ctx.annotationFacet().forEach(this::visitAnnotationFacet);
            return arrayInstance;
        });
    }

    @Override
    public Instance visitAnnotatedBooleanInstance(RAMLParser.AnnotatedBooleanInstanceContext ctx) {
        BooleanInstance booleanInstance = (BooleanInstance)this.create(TypesPackage.Literals.BOOLEAN_INSTANCE, ctx);
        booleanInstance.setValue(Boolean.valueOf(ctx.BOOL(0).getText()));
        return (Instance)this.withinScope(this.scope.with(booleanInstance), (T booleanInstanceScope) -> {
            ctx.annotationFacet().forEach(this::visitAnnotationFacet);
            return booleanInstance;
        });
    }

    @Override
    public Instance visitAnnotatedRelativeUriInstance(RAMLParser.AnnotatedRelativeUriInstanceContext ctx) {
        StringInstance stringInstance = (StringInstance)this.create(TypesPackage.Literals.STRING_INSTANCE, ctx);
        stringInstance.setValue(ctx.RELATIVE_URI(0).getText());
        return (Instance)this.withinScope(this.scope.with(stringInstance), (T stringInstanceScope) -> {
            ctx.annotationFacet().forEach(this::visitAnnotationFacet);
            return stringInstance;
        });
    }

    @Override
    public Instance visitAnnotatedStringInstance(RAMLParser.AnnotatedStringInstanceContext ctx) {
        StringInstance stringInstance = (StringInstance)this.create(TypesPackage.Literals.STRING_INSTANCE, ctx);
        stringInstance.setValue(ctx.id(0).getText());
        return (Instance)this.withinScope(this.scope.with(stringInstance), (T stringInstanceScope) -> {
            ctx.annotationFacet().forEach(this::visitAnnotationFacet);
            return stringInstance;
        });
    }

    @Override
    public Instance visitAnnotatedIntegerInstance(RAMLParser.AnnotatedIntegerInstanceContext ctx) {
        Instance instance;
        try {
            BigInteger value = new BigInteger(ctx.INT(0).getText());
            IntegerInstance integerInstance = (IntegerInstance)this.create(TypesPackage.Literals.INTEGER_INSTANCE, ctx);
            integerInstance.setValue(value);
            instance = integerInstance;
        }
        catch (NumberFormatException e) {
            StringInstance stringInstance = (StringInstance)this.create(TypesPackage.Literals.STRING_INSTANCE, ctx);
            stringInstance.setValue(ctx.INT(0).getText());
            instance = stringInstance;
        }
        StringInstance integerInstance = instance;
        return (Instance)this.withinScope(this.scope.with(integerInstance), (T integerInstanceScope) -> {
            ctx.annotationFacet().forEach(this::visitAnnotationFacet);
            return integerInstance;
        });
    }

    @Override
    public Instance visitAnnotatedNumberInstance(RAMLParser.AnnotatedNumberInstanceContext ctx) {
        NumberInstance numberInstance = (NumberInstance)this.create(TypesPackage.Literals.NUMBER_INSTANCE, ctx);
        numberInstance.setValue(new BigDecimal(ctx.FLOAT(0).getText()));
        return (Instance)this.withinScope(this.scope.with(numberInstance), (T numberInstanceScope) -> {
            ctx.annotationFacet().forEach(this::visitAnnotationFacet);
            return numberInstance;
        });
    }

    @Override
    public Instance visitRelativeUriInstance(RAMLParser.RelativeUriInstanceContext ctx) {
        StringInstance stringInstance = (StringInstance)this.create(TypesPackage.Literals.STRING_INSTANCE, ctx);
        stringInstance.setValue(ctx.getText());
        return stringInstance;
    }

    @Override
    public Instance visitStringInstance(RAMLParser.StringInstanceContext ctx) {
        if (ctx.value != null && ctx.value.start != null && ctx.value.start.getType() == 55) {
            return (Instance)this.create(TypesPackage.Literals.NULL_INSTANCE, ctx);
        }
        StringInstance stringInstance = (StringInstance)this.create(TypesPackage.Literals.STRING_INSTANCE, ctx);
        stringInstance.setValue(ctx.getText());
        return stringInstance;
    }

    @Override
    public Instance visitBooleanInstance(RAMLParser.BooleanInstanceContext ctx) {
        BooleanInstance booleanInstance = (BooleanInstance)this.create(TypesPackage.Literals.BOOLEAN_INSTANCE, ctx);
        booleanInstance.setValue(Boolean.valueOf(ctx.getText()));
        return booleanInstance;
    }

    @Override
    public Instance visitIntegerInstance(RAMLParser.IntegerInstanceContext ctx) {
        Instance instance;
        try {
            BigInteger value = new BigInteger(ctx.getText());
            IntegerInstance integerInstance = (IntegerInstance)this.create(TypesPackage.Literals.INTEGER_INSTANCE, ctx);
            integerInstance.setValue(value);
            instance = integerInstance;
        }
        catch (NumberFormatException e) {
            StringInstance stringInstance = (StringInstance)this.create(TypesPackage.Literals.STRING_INSTANCE, ctx);
            stringInstance.setValue(ctx.getText());
            instance = stringInstance;
        }
        return instance;
    }

    @Override
    public Instance visitNumberInstance(RAMLParser.NumberInstanceContext ctx) {
        NumberInstance numberInstance = (NumberInstance)this.create(TypesPackage.Literals.NUMBER_INSTANCE, ctx);
        numberInstance.setValue(new BigDecimal(ctx.getText()));
        return numberInstance;
    }

    @Override
    public Instance visitObjectInstance(RAMLParser.ObjectInstanceContext ctx) {
        ObjectInstance objectInstance = (ObjectInstance)this.create(TypesPackage.Literals.OBJECT_INSTANCE, ctx);
        this.scope.setValue(objectInstance, ctx.getStart());
        return (Instance)this.withinScope(this.scope.with(objectInstance, (EStructuralFeature)TypesPackage.Literals.OBJECT_INSTANCE__VALUE), (T propertyValuesScope) -> {
            ctx.instanceProperty().forEach(this::createInstanceProperty);
            return objectInstance;
        });
    }

    private void createInstanceProperty(RAMLParser.InstancePropertyContext ctx) {
        PropertyValue propertyValue = (PropertyValue)this.create(TypesPackage.Literals.PROPERTY_VALUE, ctx);
        this.scope.setValue(propertyValue, ctx.getStart());
        propertyValue.setName(ctx.name.getText());
        this.withinScope(this.scope.with(propertyValue, (EStructuralFeature)TypesPackage.Literals.PROPERTY_VALUE__VALUE), (T propertyValueScope) -> {
            this.visitBaseInstance(ctx.value);
            return propertyValue;
        });
    }

    @Override
    public Instance visitArrayInstance(RAMLParser.ArrayInstanceContext ctx) {
        ArrayInstance arrayInstance = (ArrayInstance)this.create(TypesPackage.Literals.ARRAY_INSTANCE, ctx);
        this.scope.setValue(arrayInstance, ctx.getStart());
        return (Instance)this.withinScope(this.scope.with(arrayInstance, (EStructuralFeature)TypesPackage.Literals.ARRAY_INSTANCE__VALUE), (T arrayInstanceScope) -> {
            ctx.baseInstance().forEach(this::visitBaseInstance);
            return arrayInstance;
        });
    }

    @Override
    public Instance visitAnnotationFacet(RAMLParser.AnnotationFacetContext annotationFacet) {
        return (Instance)this.withinScope(this.scope.with((EStructuralFeature)TypesPackage.Literals.ANNOTATIONS_FACET__ANNOTATIONS), (T annotationsScope) -> {
            Annotation annotation = (Annotation)this.create(TypesPackage.Literals.ANNOTATION, annotationFacet);
            this.scope.setValue(annotation, annotationFacet.getStart());
            String annotationTypeRef = annotationFacet.ANNOTATION_TYPE_REF().getText();
            Scope annotationTypeScope = annotationsScope.with((EStructuralFeature)TypesPackage.Literals.ANNOTATION__TYPE);
            AnyAnnotationType annotationType = (AnyAnnotationType)annotationTypeScope.getEObjectByName(annotationTypeRef);
            annotation.setType(annotationType);
            this.withinScope(annotationsScope.with(annotation, (EStructuralFeature)TypesPackage.Literals.ANNOTATION__VALUE), (T annotationValueScope) -> (Instance)this.visitInstance(annotationFacet.value));
            return (Instance)annotationsScope.getEObject();
        });
    }
}

