/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.persistence.constructor;

import io.vrap.emf.utils.URIUtils;
import io.vrap.rmf.raml.model.RamlDiagnostic;
import io.vrap.rmf.raml.model.modules.ApiExtension;
import io.vrap.rmf.raml.model.modules.Library;
import io.vrap.rmf.raml.model.modules.LibraryUse;
import io.vrap.rmf.raml.model.modules.ModulesPackage;
import io.vrap.rmf.raml.model.modules.TypeContainer;
import io.vrap.rmf.raml.model.resources.ResourcesPackage;
import io.vrap.rmf.raml.model.security.SecurityPackage;
import io.vrap.rmf.raml.model.types.BuiltinType;
import io.vrap.rmf.raml.model.types.TypesPackage;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.Token;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class Scope {
    private final Scope parent;
    private final Resource resource;
    private final URI uri;
    private final EObject eObject;
    private final EStructuralFeature feature;

    private Scope(Scope parent, Resource resource, URI uri, EObject eObject, EStructuralFeature feature) {
        this.parent = parent;
        this.resource = resource;
        this.uri = uri;
        this.eObject = eObject;
        this.feature = feature;
    }

    public Resource getResource() {
        return this.resource;
    }

    public ResourceSet getResourceSet() {
        return this.resource.getResourceSet();
    }

    public EObject getEObject() {
        return this.eObject;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    private URI getBaseUri() {
        return this.uri.trimSegments(1);
    }

    public Resource getResource(String relativePath) {
        URI uri = this.resolve(relativePath);
        return this.getResourceSet().getResource(uri, true);
    }

    private URI resolve(String relativePath) {
        String[] segments = URI.createURI((String)relativePath).segments();
        URI resolved = this.getBaseUri().appendSegments(segments);
        return URIUtils.normalize((URI)resolved);
    }

    public EObject getEObjectByName(String name) {
        EClass type = (EClass)this.feature.getEType();
        return this.getEObjectByName(name, type);
    }

    public EObject getEObjectByName(String name, EClass type) {
        String uriFragment = this.getUriFragment(name, type);
        Resource builtinTypeResource = this.getResourceSet().getResource(BuiltinType.RESOURCE_URI, true);
        EObject resolvedType = Optional.ofNullable(builtinTypeResource.getEObject(uriFragment)).orElseGet(() -> this.getEObjectByName(this.resource, name, type));
        return resolvedType;
    }

    private String getUriFragment(String id, EClass type) {
        String fragment = TypesPackage.Literals.ANY_ANNOTATION_TYPE.isSuperTypeOf(type) ? ModulesPackage.Literals.TYPE_CONTAINER__ANNOTATION_TYPES.getName() : (SecurityPackage.Literals.SECURITY_SCHEME.isSuperTypeOf(type) ? SecurityPackage.Literals.SECURITY_SCHEME_CONTAINER__SECURITY_SCHEMES.getName() : (ResourcesPackage.Literals.TRAIT.isSuperTypeOf(type) ? ModulesPackage.Literals.TYPE_CONTAINER__TRAITS.getName() : (ResourcesPackage.Literals.RESOURCE_TYPE.isSuperTypeOf(type) ? ModulesPackage.Literals.TYPE_CONTAINER__RESOURCE_TYPES.getName() : ModulesPackage.Literals.TYPE_CONTAINER__TYPES.getName())));
        return Stream.of(fragment, id).collect(Collectors.joining("/", "/", ""));
    }

    private EObject getEObjectByName(Resource resource, String name, EClass type) {
        EObject resolvedType;
        String[] segments = name.split("\\.");
        if (segments.length == 1) {
            String uriFragment = this.getUriFragment(name, type);
            resolvedType = this.getEObject(resource, type, uriFragment);
        } else if (segments.length == 2) {
            String libraryName = segments[0];
            Library usedLibrary = this.getUsedLibrary(libraryName);
            if (usedLibrary == null) {
                this.addError("Library named ''{0}'' doesn't exist in ''{1}''", libraryName, resource.getURI());
                resolvedType = null;
            } else {
                String resolvedId = segments[1];
                Scope usedLibraryScope = this.with(usedLibrary.eResource());
                resolvedType = usedLibraryScope.getEObjectByName(resolvedId);
            }
        } else {
            this.addError("Name has invalid format ''{0}''", name);
            resolvedType = null;
        }
        return resolvedType;
    }

    private EObject getEObject(Resource resource, EClass type, String uriFragment) {
        EObject resolvedType;
        EObject eObject = this.getEObject(uriFragment);
        if (eObject != null) {
            resolvedType = eObject;
        } else {
            InternalEObject internalEObject = (InternalEObject)EcoreUtil.create((EClass)type);
            internalEObject.eSetProxyURI(resource.getURI().appendFragment(uriFragment));
            resolvedType = internalEObject;
        }
        return resolvedType;
    }

    private EObject getEObject(String uriFragment) {
        EObject directEObject = this.resource.getEObject(uriFragment);
        if (directEObject == null) {
            Optional<Resource> extendsResource = this.getExtendsResource();
            EObject extendsEObject = extendsResource.map(resource -> resource.getEObject(uriFragment)).orElse(null);
            return extendsEObject;
        }
        return directEObject;
    }

    private Optional<Resource> getExtendsResource() {
        ApiExtension apiExtension;
        EObject rootObject;
        Optional first = this.resource.getContents().stream().findFirst();
        if (first.isPresent() && (rootObject = (EObject)first.get()) instanceof ApiExtension && (apiExtension = (ApiExtension)rootObject).getExtends() != null) {
            return Optional.ofNullable(apiExtension.getExtends().eResource());
        }
        return Optional.empty();
    }

    private Library getUsedLibrary(String name) {
        Optional<LibraryUse> libraryUse = this.resource.getContents().stream().filter(TypeContainer.class::isInstance).map(TypeContainer.class::cast).flatMap(typeContainer -> typeContainer.getUses().stream()).filter(LibraryUse.class::isInstance).map(LibraryUse.class::cast).filter(use -> use.getName().equals(name)).findFirst();
        return libraryUse.map(LibraryUse::getLibrary).orElse(null);
    }

    public <T> T setValue(T value, Token token) {
        EStructuralFeature feature = this.getFeature();
        return feature == null ? this.setValue(this.resource, value, token) : this.setValue(feature, value, token);
    }

    public <T> T setValue(Resource resource, T value, Token token) {
        assert (resource != null);
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            resource.getContents().addAll(values);
        } else {
            resource.getContents().add((Object)((EObject)value));
        }
        return value;
    }

    public <T> T setValue(EStructuralFeature feature, T value, Token token) {
        EList objectClass = this.eObject.eClass().getEAllStructuralFeatures();
        boolean isValidValue = objectClass.contains((Object)feature) && value != null;
        boolean isCollectionValue = value instanceof Collection;
        EClassifier eType = feature.getEType();
        if (isValidValue) {
            if (feature.isMany()) {
                if (isCollectionValue) {
                    Collection collectionValue = (Collection)value;
                    if (!collectionValue.isEmpty()) {
                        for (Object item : collectionValue) {
                            if (eType.isInstance(item)) {
                                this.addValue(feature, item);
                                continue;
                            }
                            this.addErrorWithLocation("Invalid value ''{0}'' for feature ''{1}'' of type ''{2}''", token, value, feature.getName(), this.eObject.eClass().getName());
                        }
                    }
                } else {
                    this.addValue(feature, value);
                }
            } else if (eType.isInstance(value)) {
                this.eObject.eSet(feature, value);
            } else {
                this.addErrorWithLocation("Invalid value ''{0}'' for feature ''{1}'' of type ''{2}''", token, value, feature.getName(), this.eObject.eClass().getName());
            }
        } else {
            this.addErrorWithLocation("Invalid value ''{0}'' for feature ''{1}'' of type ''{2}''", token, value, feature.getName(), this.eObject.eClass().getName());
        }
        return value;
    }

    public <T> void addValue(EStructuralFeature feature, T value) {
        assert (feature.isMany());
        assert (!(value instanceof Collection));
        EList eList = (EList)this.eObject.eGet(feature);
        eList.add(value);
    }

    public void addError(String messagePattern, Object ... arguments) {
        this.addErrorWithLocation(messagePattern, null, arguments);
    }

    public void addErrorWithLocation(String messagePattern, Token at, Object ... arguments) {
        String message = MessageFormat.format(messagePattern, arguments);
        int line = at != null ? at.getLine() : -1;
        int column = at != null ? at.getCharPositionInLine() : -1;
        String sourceName = at != null ? at.getTokenSource().getSourceName() : null;
        this.resource.getErrors().add((Object)RamlDiagnostic.of(message, sourceName, line, column));
    }

    public Scope getParent() {
        return this.parent;
    }

    public Scope with(EObject eObject) {
        return new Scope(this, this.resource, this.uri, eObject, this.feature);
    }

    public Scope with(EObject eObject, EStructuralFeature feature) {
        return new Scope(this, this.resource, this.uri, eObject, feature);
    }

    public Scope with(EStructuralFeature feature) {
        return this.with(this.eObject, feature);
    }

    public Scope with(Resource resource) {
        return new Scope(this, resource, this.uri, this.eObject, this.feature);
    }

    public static Scope of(Resource resource) {
        return new Scope(null, resource, resource.getURI(), null, null);
    }
}

