/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.persistence.constructor;

import com.google.common.collect.Streams;
import io.vrap.rmf.raml.model.modules.ModulesPackage;
import io.vrap.rmf.raml.model.types.AnyType;
import io.vrap.rmf.raml.model.types.BuiltinType;
import io.vrap.rmf.raml.model.types.TypeTemplate;
import io.vrap.rmf.raml.model.types.TypesFactory;
import io.vrap.rmf.raml.model.types.TypesPackage;
import io.vrap.rmf.raml.model.types.UnionType;
import io.vrap.rmf.raml.persistence.antlr.ParserErrorCollector;
import io.vrap.rmf.raml.persistence.antlr.TypeExpressionBaseVisitor;
import io.vrap.rmf.raml.persistence.antlr.TypeExpressionLexer;
import io.vrap.rmf.raml.persistence.antlr.TypeExpressionParser;
import io.vrap.rmf.raml.persistence.constructor.Scope;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TypeExpressionResolver {
    public EObject resolve(String typeExpression, Scope scope) {
        CodePointCharStream charStream = CharStreams.fromString((String)typeExpression);
        TypeExpressionLexer lexer = new TypeExpressionLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        TypeExpressionParser typeExpressionParser = new TypeExpressionParser((TokenStream)tokenStream);
        lexer.removeErrorListeners();
        typeExpressionParser.removeErrorListeners();
        ParserErrorCollector errorCollector = new ParserErrorCollector();
        lexer.addErrorListener((ANTLRErrorListener)errorCollector);
        typeExpressionParser.addErrorListener((ANTLRErrorListener)errorCollector);
        TypeExpressionParser.Type_exprContext typeExpr = typeExpressionParser.type_expr();
        EStructuralFeature feature = scope.getFeature();
        Object resolvedElement = feature == TypesPackage.Literals.TYPED_ELEMENT__TYPE || feature == TypesPackage.Literals.ARRAY_TYPE_FACET__ITEMS ? (EObject)new TypedElementTypeResolver(scope).visit((ParseTree)typeExpr) : (feature == ModulesPackage.Literals.TYPE_CONTAINER__TYPES ? (EObject)new TypeResolver(scope).visit((ParseTree)typeExpr) : (feature == ModulesPackage.Literals.TYPE_CONTAINER__ANNOTATION_TYPES ? (EObject)new AnnotationTypeResolver(scope).visit((ParseTree)typeExpr) : (feature == TypesPackage.Literals.ANY_TYPE__TYPE || feature == TypesPackage.Literals.ANY_ANNOTATION_TYPE__TYPE ? (EObject)new AnyTypeTypeResolver(scope).visit((ParseTree)typeExpr) : null)));
        scope.getResource().getErrors().addAll(errorCollector.getErrors());
        return resolvedElement;
    }

    private static final class AnyTypeTypeResolver
    extends TypeExpressionBaseVisitor<EObject> {
        private final Scope scope;
        private boolean nestedTypes;

        public AnyTypeTypeResolver(Scope scope) {
            this.scope = scope;
            this.nestedTypes = false;
        }

        @Override
        public EObject visitParens(TypeExpressionParser.ParensContext ctx) {
            return (EObject)super.visit((ParseTree)ctx.type_expr());
        }

        @Override
        public EObject visitIntersectionType(TypeExpressionParser.IntersectionTypeContext ctx) {
            EObject intersectionType = EcoreUtil.create((EClass)TypesPackage.Literals.INTERSECTION_TYPE);
            this.scope.addValue((EStructuralFeature)TypesPackage.Literals.INLINE_TYPE_CONTAINER__INLINE_TYPES, intersectionType);
            this.nestedTypes = true;
            Stream allExprs = Streams.concat((Stream[])new Stream[]{ctx.primary_type_expr().stream(), ctx.union_type_expr().stream()});
            List collect = allExprs.map(arg_0 -> ((AnyTypeTypeResolver)this).visit(arg_0)).collect(Collectors.toList());
            EList allOfTypes = ECollections.asEList(collect);
            this.nestedTypes = false;
            intersectionType.eSet((EStructuralFeature)TypesPackage.Literals.INTERSECTION_TYPE__ALL_OF, (Object)allOfTypes);
            return intersectionType;
        }

        @Override
        public EObject visitTypeReference(TypeExpressionParser.TypeReferenceContext ctx) {
            String typeName = ctx.getText();
            return !this.nestedTypes && BuiltinType.of(typeName).isPresent() ? null : this.scope.getEObjectByName(typeName);
        }
    }

    private static final class AnnotationTypeResolver
    extends TypeExpressionBaseVisitor<EObject> {
        private final Scope scope;
        private boolean nestedTypes;

        public AnnotationTypeResolver(Scope scope) {
            this.scope = scope;
            this.nestedTypes = false;
        }

        @Override
        public EObject visitParens(TypeExpressionParser.ParensContext ctx) {
            return (EObject)super.visit((ParseTree)ctx.type_expr());
        }

        @Override
        public EObject visitArrayType(TypeExpressionParser.ArrayTypeContext ctx) {
            EObject arrayType = EcoreUtil.create((EClass)TypesPackage.Literals.ARRAY_ANNOTATION_TYPE);
            this.nestedTypes = true;
            EObject itemsType = (EObject)this.visit((ParseTree)ctx.primary_type_expr());
            arrayType.eSet((EStructuralFeature)TypesPackage.Literals.ARRAY_TYPE_FACET__ITEMS, (Object)itemsType);
            return arrayType;
        }

        @Override
        public EObject visitUnionType(TypeExpressionParser.UnionTypeContext ctx) {
            EObject unionType = EcoreUtil.create((EClass)TypesPackage.Literals.UNION_ANNOTATION_TYPE);
            this.nestedTypes = true;
            EList oneOfType = ECollections.asEList(ctx.primary_type_expr().stream().map(arg_0 -> ((AnnotationTypeResolver)this).visit(arg_0)).filter(AnyType.class::isInstance).map(AnyType.class::cast).collect(Collectors.toList()));
            unionType.eSet((EStructuralFeature)TypesPackage.Literals.ONE_OF_FACET__ONE_OF, (Object)oneOfType);
            return unionType;
        }

        @Override
        public EObject visitTypeTemplate(TypeExpressionParser.TypeTemplateContext ctx) {
            this.scope.addErrorWithLocation("Type template not allowed here.", ctx.getStart(), new Object[0]);
            return null;
        }

        @Override
        public EObject visitTypeReference(TypeExpressionParser.TypeReferenceContext ctx) {
            EObject eObject;
            String typeName = ctx.getText();
            BuiltinType builtinType = BuiltinType.of(typeName).orElse(null);
            EObject resolved = this.nestedTypes ? this.scope.getEObjectByName(typeName, TypesPackage.Literals.ANY_TYPE) : (builtinType == null ? ((eObject = this.scope.getEObjectByName(typeName)).eIsProxy() ? eObject : EcoreUtil.create((EClass)eObject.eClass())) : EcoreUtil.create((EClass)builtinType.getAnnotationTypeDeclarationType()));
            return resolved;
        }
    }

    private static final class TypeResolver
    extends TypeExpressionBaseVisitor<EObject> {
        private final Scope scope;
        private boolean nestedTypes;

        public TypeResolver(Scope scope) {
            this.scope = scope;
            this.nestedTypes = false;
        }

        @Override
        public EObject visitParens(TypeExpressionParser.ParensContext ctx) {
            return (EObject)super.visit((ParseTree)ctx.type_expr());
        }

        @Override
        public EObject visitArrayType(TypeExpressionParser.ArrayTypeContext ctx) {
            EObject arrayType = EcoreUtil.create((EClass)TypesPackage.Literals.ARRAY_TYPE);
            this.scope.addValue((EStructuralFeature)TypesPackage.Literals.INLINE_TYPE_CONTAINER__INLINE_TYPES, arrayType);
            this.nestedTypes = true;
            EObject itemsType = (EObject)this.visit((ParseTree)ctx.primary_type_expr());
            arrayType.eSet((EStructuralFeature)TypesPackage.Literals.ARRAY_TYPE_FACET__ITEMS, (Object)itemsType);
            return arrayType;
        }

        @Override
        public EObject visitIntersectionType(TypeExpressionParser.IntersectionTypeContext ctx) {
            EObject type = ctx.primary_type_expr().isEmpty() ? this.scope.getEObjectByName("object") : this.scope.getEObjectByName(ctx.primary_type_expr(0).getText());
            return type.eIsProxy() ? type : EcoreUtil.create((EClass)type.eClass());
        }

        @Override
        public EObject visitUnionType(TypeExpressionParser.UnionTypeContext ctx) {
            EObject unionType = EcoreUtil.create((EClass)TypesPackage.Literals.UNION_TYPE);
            this.scope.addValue((EStructuralFeature)TypesPackage.Literals.INLINE_TYPE_CONTAINER__INLINE_TYPES, unionType);
            this.nestedTypes = true;
            EList oneOfType = ECollections.asEList(ctx.primary_type_expr().stream().map(arg_0 -> ((TypeResolver)this).visit(arg_0)).filter(AnyType.class::isInstance).map(AnyType.class::cast).collect(Collectors.toList()));
            unionType.eSet((EStructuralFeature)TypesPackage.Literals.ONE_OF_FACET__ONE_OF, (Object)oneOfType);
            return unionType;
        }

        @Override
        public EObject visitTypeTemplate(TypeExpressionParser.TypeTemplateContext ctx) {
            this.scope.addErrorWithLocation("Type template not allowed here.", ctx.getStart(), new Object[0]);
            return null;
        }

        @Override
        public EObject visitTypeReference(TypeExpressionParser.TypeReferenceContext ctx) {
            EObject eObject;
            String typeName = ctx.getText();
            BuiltinType builtinType = BuiltinType.of(typeName).orElse(null);
            EObject resolved = this.nestedTypes ? this.scope.getEObjectByName(typeName) : (builtinType == null ? ((eObject = this.scope.getEObjectByName(typeName)).eIsProxy() ? eObject : EcoreUtil.create((EClass)eObject.eClass())) : EcoreUtil.create((EClass)builtinType.getTypeDeclarationType()));
            return resolved;
        }
    }

    private static final class TypedElementTypeResolver
    extends TypeExpressionBaseVisitor<EObject> {
        private final Scope scope;

        public TypedElementTypeResolver(Scope scope) {
            this.scope = scope;
        }

        @Override
        public EObject visitParens(TypeExpressionParser.ParensContext ctx) {
            return (EObject)super.visit((ParseTree)ctx.type_expr());
        }

        @Override
        public EObject visitArrayType(TypeExpressionParser.ArrayTypeContext ctx) {
            EObject arrayType = EcoreUtil.create((EClass)TypesPackage.Literals.ARRAY_TYPE);
            this.scope.addValue((EStructuralFeature)TypesPackage.Literals.INLINE_TYPE_CONTAINER__INLINE_TYPES, arrayType);
            EObject itemsType = (EObject)this.visit((ParseTree)ctx.primary_type_expr());
            arrayType.eSet((EStructuralFeature)TypesPackage.Literals.ARRAY_TYPE_FACET__ITEMS, (Object)itemsType);
            return arrayType;
        }

        @Override
        public EObject visitIntersectionType(TypeExpressionParser.IntersectionTypeContext ctx) {
            EObject intersectionType = EcoreUtil.create((EClass)TypesPackage.Literals.INTERSECTION_TYPE);
            this.scope.addValue((EStructuralFeature)TypesPackage.Literals.INLINE_TYPE_CONTAINER__INLINE_TYPES, intersectionType);
            Stream typeExprs = Streams.concat((Stream[])new Stream[]{ctx.primary_type_expr().stream(), ctx.union_type_expr().stream()});
            EList allOfTypes = ECollections.asEList(typeExprs.map(arg_0 -> ((TypedElementTypeResolver)this).visit(arg_0)).collect(Collectors.toList()));
            intersectionType.eSet((EStructuralFeature)TypesPackage.Literals.INTERSECTION_TYPE__ALL_OF, (Object)allOfTypes);
            return intersectionType;
        }

        @Override
        public EObject visitUnionType(TypeExpressionParser.UnionTypeContext ctx) {
            UnionType unionType = (UnionType)EcoreUtil.create((EClass)TypesPackage.Literals.UNION_TYPE);
            this.scope.addValue((EStructuralFeature)TypesPackage.Literals.INLINE_TYPE_CONTAINER__INLINE_TYPES, unionType);
            EList oneOfType = ECollections.asEList(ctx.primary_type_expr().stream().map(arg_0 -> ((TypedElementTypeResolver)this).visit(arg_0)).filter(AnyType.class::isInstance).map(AnyType.class::cast).collect(Collectors.toList()));
            unionType.getOneOf().addAll((Collection)oneOfType);
            return unionType;
        }

        @Override
        public EObject visitTypeTemplate(TypeExpressionParser.TypeTemplateContext ctx) {
            TypeTemplate typeTemplate = TypesFactory.eINSTANCE.createTypeTemplate();
            this.scope.addValue((EStructuralFeature)TypesPackage.Literals.INLINE_TYPE_CONTAINER__INLINE_TYPES, typeTemplate);
            typeTemplate.setName(ctx.getText());
            return typeTemplate;
        }

        @Override
        public EObject visitTypeReference(TypeExpressionParser.TypeReferenceContext ctx) {
            String typeName = ctx.getText();
            EObject anyType = this.scope.getEObjectByName(typeName);
            return anyType;
        }
    }
}

