/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.validation;

import com.google.common.base.Strings;
import io.vrap.rmf.raml.model.types.Annotation;
import io.vrap.rmf.raml.model.types.AnyTypeFacet;
import io.vrap.rmf.raml.model.types.ArrayInstance;
import io.vrap.rmf.raml.model.types.ArrayTypeFacet;
import io.vrap.rmf.raml.model.types.BuiltinType;
import io.vrap.rmf.raml.model.types.CommonNumberTypeFacet;
import io.vrap.rmf.raml.model.types.DateOnlyType;
import io.vrap.rmf.raml.model.types.DateTime;
import io.vrap.rmf.raml.model.types.DateTimeFormat;
import io.vrap.rmf.raml.model.types.DateTimeOnlyType;
import io.vrap.rmf.raml.model.types.DateTimeType;
import io.vrap.rmf.raml.model.types.DateTimeTypeFacet;
import io.vrap.rmf.raml.model.types.Instance;
import io.vrap.rmf.raml.model.types.IntegerInstance;
import io.vrap.rmf.raml.model.types.IntegerTypeFacet;
import io.vrap.rmf.raml.model.types.NilType;
import io.vrap.rmf.raml.model.types.NumberInstance;
import io.vrap.rmf.raml.model.types.NumberTypeFacet;
import io.vrap.rmf.raml.model.types.ObjectInstance;
import io.vrap.rmf.raml.model.types.ObjectType;
import io.vrap.rmf.raml.model.types.ObjectTypeFacet;
import io.vrap.rmf.raml.model.types.Property;
import io.vrap.rmf.raml.model.types.PropertyValue;
import io.vrap.rmf.raml.model.types.StringInstance;
import io.vrap.rmf.raml.model.types.StringTypeFacet;
import io.vrap.rmf.raml.model.types.TimeOnlyType;
import io.vrap.rmf.raml.model.types.TypeTemplate;
import io.vrap.rmf.raml.model.types.TypesPackage;
import io.vrap.rmf.raml.model.types.util.TypesSwitch;
import io.vrap.rmf.raml.model.util.InstanceHelper;
import io.vrap.rmf.raml.model.util.ModelHelper;
import io.vrap.rmf.raml.validation.DiagnosticsCreator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class InstanceValidator
implements DiagnosticsCreator {
    private static final DateTimeFormatter rfc3339 = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private static final DateTimeFormatter rfc2616 = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz").withLocale(Locale.ENGLISH);

    public List<Diagnostic> validate(Instance instance, AnyTypeFacet type) {
        return this.validateInternal(instance, type, false);
    }

    public List<Diagnostic> validate(Instance instance, AnyTypeFacet type, Boolean strict) {
        return this.validateInternal(instance, type, strict);
    }

    public List<Diagnostic> validate(Annotation annotation) {
        return this.validateInternal(annotation.getValue(), annotation.getType(), false);
    }

    private List<Diagnostic> validateInternal(Instance instance, EObject type, Boolean strict) {
        InstanceValidatingVisitor validatingVisitor = new InstanceValidatingVisitor(type, strict);
        List validationResults = (List)validatingVisitor.doSwitch(instance);
        return validationResults;
    }

    private List<Diagnostic> validateEnumFacet(AnyTypeFacet anyTypeFacet, Instance instance) {
        Object value = instance.getValue();
        ArrayList<Diagnostic> validationResults = new ArrayList<Diagnostic>();
        if (anyTypeFacet.getEnum().isEmpty() && anyTypeFacet.getType() != null) {
            return this.validateEnumFacet(anyTypeFacet.getType(), instance);
        }
        Optional<Instance> enumInstance = anyTypeFacet.getEnum().stream().filter(enumValue -> enumValue.getValue().equals(value)).findFirst();
        if (anyTypeFacet.getEnum().size() > 0 && !enumInstance.isPresent()) {
            String enumValues = anyTypeFacet.getEnum().stream().map(e -> e.getValue().toString()).collect(Collectors.joining(",", "[", "]"));
            validationResults.add(this.error(instance, "Value ''{0}'' is not defined in enum facet ''{1}''", value, enumValues));
        }
        return validationResults;
    }

    private class DateValidator
    extends TypesSwitch<Diagnostic> {
        private final StringInstance value;

        private DateValidator(StringInstance value) {
            this.value = value;
        }

        @Override
        public Diagnostic caseDateOnlyType(DateOnlyType dateOnlyType) {
            return this.validate(DateTimeFormatter.ISO_LOCAL_DATE, dateOnlyType);
        }

        @Override
        public Diagnostic caseDateTimeOnlyType(DateTimeOnlyType dateTimeOnlyType) {
            return this.validate(DateTimeFormatter.ISO_LOCAL_DATE_TIME, dateTimeOnlyType);
        }

        @Override
        public Diagnostic caseTimeOnlyType(TimeOnlyType timeOnlyType) {
            return this.validate(DateTimeFormatter.ISO_LOCAL_TIME, timeOnlyType);
        }

        @Override
        public Diagnostic caseDateTimeType(DateTimeType dateTimeType) {
            DateTimeFormatter dateTimeFormatter = dateTimeType.getFormat().equals((Object)DateTimeFormat.RFC2616) ? rfc2616 : rfc3339;
            return this.validate(dateTimeFormatter, dateTimeType);
        }

        private Diagnostic validate(DateTimeFormatter dateTimeFormatter, DateTime type) {
            try {
                dateTimeFormatter.parse(this.value.getValue());
                return null;
            }
            catch (DateTimeParseException e) {
                return InstanceValidator.this.error(this.value, e.getMessage(), new Object[0]);
            }
        }
    }

    private class InstanceValidatingVisitor
    extends TypesSwitch<List<Diagnostic>> {
        private final Boolean strictMode;
        private final Stack<EObject> types = new Stack();

        public InstanceValidatingVisitor(EObject type, Boolean strictMode) {
            this.types.push(type);
            this.strictMode = strictMode;
        }

        @Override
        public List<Diagnostic> defaultCase(EObject object) {
            return Collections.emptyList();
        }

        @Override
        public List<Diagnostic> caseStringInstance(StringInstance stringInstance) {
            ArrayList<Diagnostic> validationResults = new ArrayList<Diagnostic>();
            if (this.typeIs(TypesPackage.Literals.UNION_TYPE)) {
                return validationResults;
            }
            String value = stringInstance.getValue();
            if (this.typeInstanceOf(StringTypeFacet.class)) {
                StringTypeFacet stringType = (StringTypeFacet)this.types.peek();
                if (stringType.getMinLength() != null && value.length() < stringType.getMinLength()) {
                    validationResults.add(InstanceValidator.this.error(stringInstance, "Value length ''{0}'' < minLength ''{1}''", value.length(), stringType.getMinLength()));
                }
                if (stringType.getMaxLength() != null && value.length() > stringType.getMaxLength()) {
                    validationResults.add(InstanceValidator.this.error(stringInstance, "Value length ''{0}'' > maxLength ''{1}''", value.length(), stringType.getMaxLength()));
                }
                if (stringType.getPattern() != null && !stringType.getPattern().test(value)) {
                    validationResults.add(InstanceValidator.this.error(stringInstance, "Value ''{0}'' doesn't match pattern ''{1}''", value, stringType.getPattern()));
                }
                validationResults.addAll(InstanceValidator.this.validateEnumFacet(stringType, stringInstance));
            } else if (this.typeInstanceOf(NilType.class)) {
                if (!Strings.isNullOrEmpty((String)value)) {
                    validationResults.add(InstanceValidator.this.error(stringInstance, "Value must be empty", new Object[0]));
                }
            } else {
                if (this.typeIs(TypesPackage.Literals.ARRAY_TYPE) && value.trim().startsWith("[") && value.trim().endsWith("]")) {
                    return (List)this.doSwitch(InstanceHelper.parseJson(value, InstanceHelper.resourceFile(stringInstance)));
                }
                if (this.typeIs(TypesPackage.Literals.OBJECT_TYPE) && value.trim().startsWith("{") && value.trim().endsWith("}")) {
                    return (List)this.doSwitch(InstanceHelper.parseJson(value, InstanceHelper.resourceFile(stringInstance)));
                }
                if (this.typeInstanceOf(DateTime.class)) {
                    Diagnostic diagnostic = (Diagnostic)new DateValidator(stringInstance).doSwitch(this.types.peek());
                    if (diagnostic != null) {
                        validationResults.add(diagnostic);
                    }
                } else if (!(this.typeIs(TypesPackage.Literals.ANY_TYPE) || this.typeInstanceOf(DateTimeTypeFacet.class) || this.typeInstanceOf(TypeTemplate.class) || this.typeIs(TypesPackage.Literals.ANY_ANNOTATION_TYPE))) {
                    validationResults.add(InstanceValidator.this.error(stringInstance, "Invalid type", new Object[0]));
                }
            }
            return validationResults;
        }

        @Override
        public List<Diagnostic> caseNumberInstance(NumberInstance numberInstance) {
            ArrayList<Diagnostic> validationResults = new ArrayList<Diagnostic>();
            if (this.typeIs(TypesPackage.Literals.UNION_TYPE)) {
                return validationResults;
            }
            if (this.typeInstanceOf(NumberTypeFacet.class)) {
                NumberTypeFacet numberType = (NumberTypeFacet)this.types.peek();
                BigDecimal value = numberInstance.getValue();
                if (numberType.getMinimum() != null && value.compareTo(numberType.getMinimum()) < 0) {
                    validationResults.add(InstanceValidator.this.error(numberInstance, "Value ''{0}'' < minimum ''{1}''", numberInstance.getValue(), numberType.getMinimum()));
                }
                if (numberType.getMaximum() != null && value.compareTo(numberType.getMaximum()) > 0) {
                    validationResults.add(InstanceValidator.this.error(numberInstance, "Value ''{0}'' > maximum ''{1}''", numberInstance.getValue(), numberType.getMaximum()));
                }
                if (numberType.getMultipleOf() != null && value.remainder(BigDecimal.valueOf(numberType.getMultipleOf().intValue())).compareTo(BigDecimal.ZERO) != 0) {
                    validationResults.add(InstanceValidator.this.error(numberInstance, "Value ''{0}'' is not a multiple of ''{1}''", value, numberType.getMultipleOf()));
                }
                validationResults.addAll(InstanceValidator.this.validateEnumFacet(numberType, numberInstance));
            } else if (!this.typeIs(TypesPackage.Literals.ANY_TYPE) && !this.typeIs(TypesPackage.Literals.ANY_ANNOTATION_TYPE)) {
                validationResults.add(InstanceValidator.this.error(numberInstance, "Invalid type", new Object[0]));
            }
            return validationResults;
        }

        @Override
        public List<Diagnostic> caseIntegerInstance(IntegerInstance integerInstance) {
            ArrayList<Diagnostic> validationResults = new ArrayList<Diagnostic>();
            BigInteger value = integerInstance.getValue();
            if (this.typeIs(TypesPackage.Literals.UNION_TYPE)) {
                return validationResults;
            }
            if (this.typeInstanceOf(CommonNumberTypeFacet.class)) {
                CommonNumberTypeFacet commonNumberType = (CommonNumberTypeFacet)this.types.peek();
                if (commonNumberType.getMultipleOf() != null && !value.mod(BigInteger.valueOf(commonNumberType.getMultipleOf().intValue())).equals(BigInteger.ZERO)) {
                    validationResults.add(InstanceValidator.this.error(integerInstance, "Value ''{0}'' is not a multiple of ''{1}''", value, commonNumberType.getMultipleOf()));
                }
                validationResults.addAll(InstanceValidator.this.validateEnumFacet(commonNumberType, integerInstance));
            }
            if (this.typeInstanceOf(IntegerTypeFacet.class)) {
                IntegerTypeFacet integerType = (IntegerTypeFacet)this.types.peek();
                if (integerType.getMinimum() != null && value.compareTo(BigInteger.valueOf(integerType.getMinimum().intValue())) < 0) {
                    validationResults.add(InstanceValidator.this.error(integerInstance, "Value ''{0}'' < minimum ''{1}''", value, integerType.getMinimum()));
                }
                if (integerType.getMaximum() != null && value.compareTo(BigInteger.valueOf(integerType.getMaximum().intValue())) > 0) {
                    validationResults.add(InstanceValidator.this.error(integerInstance, "Value ''{0}'' > maximum ''{1}''", value, integerType.getMaximum()));
                }
            } else if (this.typeInstanceOf(NumberTypeFacet.class)) {
                NumberTypeFacet numberType = (NumberTypeFacet)this.types.peek();
                if (numberType.getMinimum() != null && value.compareTo(BigInteger.valueOf(numberType.getMinimum().longValue())) < 0) {
                    validationResults.add(InstanceValidator.this.error(integerInstance, "Value ''{0}'' < minimum ''{1}''", value, numberType.getMinimum()));
                }
                if (numberType.getMaximum() != null && value.compareTo(BigInteger.valueOf(numberType.getMaximum().longValue())) > 0) {
                    validationResults.add(InstanceValidator.this.error(integerInstance, "Value ''{0}'' > maximum ''{1}''", value, numberType.getMaximum()));
                }
            } else if (!this.typeIs(TypesPackage.Literals.ANY_TYPE) && !this.typeIs(TypesPackage.Literals.ANY_ANNOTATION_TYPE)) {
                validationResults.add(InstanceValidator.this.error(integerInstance, "Invalid type", new Object[0]));
            }
            return validationResults;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Diagnostic> caseArrayInstance(ArrayInstance arrayInstance) {
            ArrayList<Diagnostic> validationResults = new ArrayList<Diagnostic>();
            if (this.typeIs(TypesPackage.Literals.UNION_TYPE)) {
                return validationResults;
            }
            if (this.typeInstanceOf(ArrayTypeFacet.class)) {
                ArrayTypeFacet arrayType = (ArrayTypeFacet)this.types.peek();
                EList<Instance> values = arrayInstance.getValue();
                if (arrayType.getMinItems() != null && values.size() < arrayType.getMinItems()) {
                    validationResults.add(InstanceValidator.this.error(arrayInstance, "Array size ''{0}'' < minItems ''{1}''", values.size(), arrayType.getMinItems()));
                }
                if (arrayType.getMaxItems() != null && values.size() > arrayType.getMaxItems()) {
                    validationResults.add(InstanceValidator.this.error(arrayInstance, "Array size  ''{0}'' > maxItems ''{1}''", values.size(), arrayType.getMaxItems()));
                }
                if (arrayType.getUniqueItems() != null && arrayType.getUniqueItems().booleanValue()) {
                    HashSet uniqueItems = new HashSet();
                    Set duplicateValues = values.stream().filter(value -> !uniqueItems.add(value.getValue())).collect(Collectors.toSet());
                    if (duplicateValues.size() > 0) {
                        validationResults.add(InstanceValidator.this.error(arrayInstance, "Array instance contains duplicate values", new Object[0]));
                    }
                }
                if (arrayType.getItems() != null) {
                    try {
                        this.types.push(arrayType.getItems());
                        values.stream().flatMap(instance -> ((List)this.doSwitch((EObject)instance)).stream()).forEach(validationResults::add);
                    }
                    finally {
                        this.types.pop();
                    }
                }
            } else if (!this.typeIs(TypesPackage.Literals.ANY_TYPE) && !this.typeIs(TypesPackage.Literals.ANY_ANNOTATION_TYPE)) {
                validationResults.add(InstanceValidator.this.error(arrayInstance, "Invalid type", new Object[0]));
            }
            return validationResults;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Diagnostic> caseObjectInstance(ObjectInstance objectInstance) {
            ArrayList<Diagnostic> validationResults = new ArrayList<Diagnostic>();
            if (this.typeIs(TypesPackage.Literals.UNION_TYPE)) {
                return validationResults;
            }
            if (this.typeInstanceOf(ObjectTypeFacet.class)) {
                ObjectTypeFacet actualObjectTypeFacet;
                ObjectTypeFacet objectTypeFacet = (ObjectTypeFacet)this.types.peek();
                String discriminator = objectTypeFacet.discriminator();
                if (Strings.isNullOrEmpty((String)discriminator)) {
                    actualObjectTypeFacet = objectTypeFacet;
                } else {
                    Instance discriminatorValueInstance = objectInstance.getValue(discriminator);
                    if (discriminatorValueInstance instanceof StringInstance) {
                        String discriminatorValue = ((StringInstance)discriminatorValueInstance).getValue();
                        ObjectType subType = objectTypeFacet.getType(discriminatorValue);
                        if (subType == null) {
                            validationResults.add(InstanceValidator.this.error(objectInstance, "Invalid discriminator value ''{0}'' for type ''{1}''", discriminatorValue, objectTypeFacet.getName()));
                        }
                        actualObjectTypeFacet = subType == null ? objectTypeFacet : subType;
                    } else {
                        actualObjectTypeFacet = objectTypeFacet;
                    }
                }
                if (BuiltinType.OBJECT.getName().equals(actualObjectTypeFacet.getName()) && actualObjectTypeFacet.getProperties().size() == 0) {
                    return validationResults;
                }
                for (PropertyValue propertyValue : objectInstance.getValue()) {
                    String name = propertyValue.getName();
                    Property property2 = actualObjectTypeFacet.getProperty(name);
                    if (property2 != null) {
                        try {
                            this.types.push(property2.getType());
                            List propertyValidationResults = (List)this.doSwitch(propertyValue.getValue());
                            validationResults.addAll(propertyValidationResults);
                            continue;
                        }
                        finally {
                            this.types.pop();
                            continue;
                        }
                    }
                    if (objectTypeFacet.additionalPropertiesInherited() != Boolean.FALSE && this.strictMode != Boolean.TRUE) continue;
                    validationResults.add(InstanceValidator.this.error(objectInstance, "Property ''{0}'' not defined", name));
                }
                Map<String, Property> allProperties = ModelHelper.getAllPropertiesAsMap(actualObjectTypeFacet);
                List missingRequiredPropertyErrors = allProperties.values().stream().filter(property -> property.getRequired() != null && property.getRequired() != false).filter(property -> objectInstance.getValue(property.getName()) == null).map(property -> InstanceValidator.this.error(objectInstance, "Required property ''{0}'' is missing", property.getName())).collect(Collectors.toList());
                validationResults.addAll(missingRequiredPropertyErrors);
            }
            return validationResults;
        }

        private boolean typeInstanceOf(Class<?> clazz) {
            return !this.types.empty() && clazz.isInstance(this.types.peek());
        }

        private boolean typeIs(EClass eClass) {
            return !this.types.empty() && this.types.peek().eClass() == eClass;
        }
    }
}

