/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.validation;

import io.vrap.rmf.raml.model.modules.Api;
import io.vrap.rmf.raml.model.modules.ApiBase;
import io.vrap.rmf.raml.model.modules.util.ModulesSwitch;
import io.vrap.rmf.raml.validation.AbstractRamlValidator;
import io.vrap.rmf.raml.validation.ProtocolFacetsValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

class ModulesValidator
extends AbstractRamlValidator {
    private final ProtocolFacetsValidator protocolFacetsValidator = new ProtocolFacetsValidator();
    private final ModulesValidatingVisitor visitor = new ModulesValidatingVisitor();

    ModulesValidator() {
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ArrayList validationErrors = new ArrayList();
        validationErrors.addAll((Collection)this.visitor.doSwitch(eObject));
        validationErrors.forEach(arg_0 -> ((DiagnosticChain)diagnostics).add(arg_0));
        return validationErrors.isEmpty();
    }

    private class ModulesValidatingVisitor
    extends ModulesSwitch<List<Diagnostic>> {
        private ModulesValidatingVisitor() {
        }

        @Override
        public List<Diagnostic> defaultCase(EObject object) {
            return Collections.emptyList();
        }

        @Override
        public List<Diagnostic> caseApiBase(ApiBase apiBase) {
            return ModulesValidator.this.protocolFacetsValidator.validate(apiBase);
        }

        @Override
        public List<Diagnostic> caseApi(Api api) {
            ArrayList<Diagnostic> validationErrors = new ArrayList<Diagnostic>();
            validationErrors.addAll((Collection<Diagnostic>)this.caseApiBase(api));
            validationErrors.addAll(this.noDuplicateResourcePaths(api));
            return validationErrors;
        }

        private List<Diagnostic> noDuplicateResourcePaths(Api api) {
            List allResources = api.getResources().stream().flatMap(r -> r.getAllContainedResources().stream()).collect(Collectors.toList());
            allResources.addAll(api.getResources());
            HashSet resourcePaths = new HashSet();
            return allResources.stream().filter(r -> {
                String resourcePath = r.getResourcePath();
                return resourcePath.length() > 0 && !resourcePaths.add(resourcePath);
            }).map(r -> ModulesValidator.this.error((EObject)r, "Duplicate resource ''{0}''", new Object[]{r.getFullUri().getTemplate()})).collect(Collectors.toList());
        }
    }
}

