/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.validation;

import io.vrap.rmf.raml.model.values.ValuesPackage;
import io.vrap.rmf.raml.validation.AbstractRamlValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

class RamlObjectValidator
extends AbstractRamlValidator {
    RamlObjectValidator() {
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ArrayList<Diagnostic> validationErrors = new ArrayList<Diagnostic>();
        validationErrors.addAll(this.requiredAttributesMustBeSet(eClass, eObject, diagnostics));
        validationErrors.addAll(this.requiredStringAttributesMustBeNonEmpty(eClass, eObject, diagnostics));
        validationErrors.addAll(this.validatePositiveIntegerAttributes(eClass, eObject, diagnostics));
        validationErrors.addAll(this.validateUnsignedIntegerAttributes(eClass, eObject, diagnostics));
        validationErrors.forEach(arg_0 -> ((DiagnosticChain)diagnostics).add(arg_0));
        return validationErrors.isEmpty();
    }

    private List<Diagnostic> requiredAttributesMustBeSet(EClass eClass, EObject eObject, DiagnosticChain diagnostics) {
        List<Diagnostic> missingRequiredAttributes = eClass.getEAllAttributes().stream().filter(eAttribute -> eAttribute.isRequired() && !eAttribute.isMany() && !eObject.eIsSet((EStructuralFeature)eAttribute)).map(eAttribute -> this.error(eObject, "Facet ''{0}'' is required.", new Object[]{eAttribute.getName()})).collect(Collectors.toList());
        return missingRequiredAttributes;
    }

    private List<Diagnostic> requiredStringAttributesMustBeNonEmpty(EClass eClass, EObject eObject, DiagnosticChain diagnostics) {
        List<Diagnostic> missingRequiredAttributes = eClass.getEAllAttributes().stream().filter(eAttribute -> eAttribute.isRequired() && !eAttribute.isMany() && eAttribute.getEAttributeType().getInstanceClass() == String.class && eObject.eIsSet((EStructuralFeature)eAttribute) && ((String)eObject.eGet((EStructuralFeature)eAttribute)).isEmpty()).map(eAttribute -> this.error(eObject, "Facet ''{0}'' must be non-empty.", new Object[]{eAttribute.getName()})).collect(Collectors.toList());
        return missingRequiredAttributes;
    }

    private List<Diagnostic> validatePositiveIntegerAttributes(EClass eClass, EObject eObject, DiagnosticChain diagnostics) {
        List<Diagnostic> missingRequiredAttributes = eClass.getEAllAttributes().stream().filter(eAttribute -> !eAttribute.isMany() && eAttribute.getEAttributeType() == ValuesPackage.Literals.POSITIVE_INTEGER && eObject.eIsSet((EStructuralFeature)eAttribute) && (Integer)eObject.eGet((EStructuralFeature)eAttribute) <= 0).map(eAttribute -> this.error(eObject, "Facet ''{0}'' must > 0.", new Object[]{eAttribute.getName()})).collect(Collectors.toList());
        return missingRequiredAttributes;
    }

    private List<Diagnostic> validateUnsignedIntegerAttributes(EClass eClass, EObject eObject, DiagnosticChain diagnostics) {
        List<Diagnostic> missingRequiredAttributes = eClass.getEAllAttributes().stream().filter(eAttribute -> !eAttribute.isMany() && eAttribute.getEAttributeType() == ValuesPackage.Literals.UNSIGNED_INTEGER && eObject.eGet((EStructuralFeature)eAttribute) != null && (Integer)eObject.eGet((EStructuralFeature)eAttribute) < 0).map(eAttribute -> this.error(eObject, "Facet ''{0}'' must >= 0.", new Object[]{eAttribute.getName()})).collect(Collectors.toList());
        return missingRequiredAttributes;
    }
}

