/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.validation;

import io.vrap.rmf.raml.model.elements.ElementsPackage;
import io.vrap.rmf.raml.model.modules.ModulesPackage;
import io.vrap.rmf.raml.model.resources.ResourcesPackage;
import io.vrap.rmf.raml.model.responses.ResponsesPackage;
import io.vrap.rmf.raml.model.security.SecurityPackage;
import io.vrap.rmf.raml.model.types.TypesPackage;
import io.vrap.rmf.raml.model.values.ValuesPackage;
import io.vrap.rmf.raml.validation.CompositeValidator;
import io.vrap.rmf.raml.validation.ModulesValidator;
import io.vrap.rmf.raml.validation.RamlObjectValidator;
import io.vrap.rmf.raml.validation.RamlValidator;
import io.vrap.rmf.raml.validation.ResourcesValidator;
import io.vrap.rmf.raml.validation.ResponsesValidator;
import io.vrap.rmf.raml.validation.TypesValidator;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.EValidatorRegistryImpl;
import org.eclipse.emf.ecore.util.Diagnostician;

public interface RamlValidationSetup {
    public static final List<EPackage> PACKAGES = Arrays.asList(ElementsPackage.eINSTANCE, ValuesPackage.eINSTANCE, ModulesPackage.eINSTANCE, ResourcesPackage.eINSTANCE, ResponsesPackage.eINSTANCE, SecurityPackage.eINSTANCE, TypesPackage.eINSTANCE);

    public static Diagnostician setupCustom(List<RamlValidator> customValidators) {
        EValidatorRegistryImpl registry = new EValidatorRegistryImpl();
        List<EValidator> eValidators = customValidators.stream().map(ramlValidator -> ramlValidator).collect(Collectors.toList());
        registry.put((Object)TypesPackage.eINSTANCE, (Object)new TypesValidator());
        registry.put((Object)ModulesPackage.eINSTANCE, (Object)new ModulesValidator());
        registry.put((Object)ResourcesPackage.eINSTANCE, (Object)new ResourcesValidator());
        registry.put((Object)ResponsesPackage.eINSTANCE, (Object)new ResponsesValidator());
        RamlObjectValidator ramlObjectValidator = new RamlObjectValidator();
        for (EPackage ePackage : PACKAGES) {
            CompositeValidator compositeValidator = new CompositeValidator();
            compositeValidator.add(ramlObjectValidator);
            EValidator validator = registry.getEValidator(ePackage);
            if (validator != null) {
                compositeValidator.add(validator);
            }
            if (eValidators.size() > 0) {
                compositeValidator.addAll(eValidators);
            }
            registry.put((Object)ePackage, (Object)compositeValidator);
        }
        return new Diagnostician((EValidator.Registry)registry);
    }

    public static Diagnostician setupCustomOnly(List<RamlValidator> customValidators) {
        EValidatorRegistryImpl registry = new EValidatorRegistryImpl();
        List<EValidator> eValidators = customValidators.stream().map(ramlValidator -> ramlValidator).collect(Collectors.toList());
        for (EPackage ePackage : PACKAGES) {
            CompositeValidator compositeValidator = new CompositeValidator();
            EValidator validator = registry.getEValidator(ePackage);
            if (validator != null) {
                compositeValidator.add(validator);
            }
            if (eValidators.size() > 0) {
                compositeValidator.addAll(eValidators);
            }
            registry.put((Object)ePackage, (Object)compositeValidator);
        }
        return new Diagnostician((EValidator.Registry)registry);
    }

    public static void setup() {
        EValidator.Registry registry = EValidator.Registry.INSTANCE;
        PACKAGES.forEach(arg_0 -> registry.remove(arg_0));
        registry.put((Object)TypesPackage.eINSTANCE, (Object)new TypesValidator());
        registry.put((Object)ModulesPackage.eINSTANCE, (Object)new ModulesValidator());
        registry.put((Object)ResourcesPackage.eINSTANCE, (Object)new ResourcesValidator());
        registry.put((Object)ResponsesPackage.eINSTANCE, (Object)new ResponsesValidator());
        RamlObjectValidator ramlObjectValidator = new RamlObjectValidator();
        for (EPackage ePackage : PACKAGES) {
            CompositeValidator compositeValidator = new CompositeValidator();
            compositeValidator.add(ramlObjectValidator);
            EValidator validator = registry.getEValidator(ePackage);
            if (validator != null) {
                compositeValidator.add(validator);
            }
            registry.put((Object)ePackage, (Object)compositeValidator);
        }
    }
}

