/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.validation;

import io.vrap.rmf.raml.model.modules.Api;
import io.vrap.rmf.raml.model.responses.Body;
import io.vrap.rmf.raml.model.responses.util.ResponsesSwitch;
import io.vrap.rmf.raml.validation.AbstractRamlValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

class ResponsesValidator
extends AbstractRamlValidator {
    ResponsesValidator() {
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List validationErrors = (List)new ResponsesValidatingVisitor().doSwitch(eObject);
        validationErrors.forEach(arg_0 -> ((DiagnosticChain)diagnostics).add(arg_0));
        return validationErrors.isEmpty();
    }

    private class ResponsesValidatingVisitor
    extends ResponsesSwitch<List<Diagnostic>> {
        private ResponsesValidatingVisitor() {
        }

        @Override
        public List<Diagnostic> defaultCase(EObject object) {
            return Collections.emptyList();
        }

        @Override
        public List<Diagnostic> caseBody(Body body) {
            List<Diagnostic> validationErrors = this.contentTypeMustBeDefined(body);
            return validationErrors;
        }

        private List<Diagnostic> contentTypeMustBeDefined(Body body) {
            boolean contentTypesDefined;
            ArrayList<Diagnostic> validationErrors = new ArrayList<Diagnostic>();
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)body);
            if (rootContainer instanceof Api) {
                Api api = (Api)rootContainer;
                contentTypesDefined = api.getMediaType().size() > 0 || body.getContentType() != null;
            } else {
                boolean bl = contentTypesDefined = body.getContentType() != null;
            }
            if (!contentTypesDefined) {
                validationErrors.add(ResponsesValidator.this.error(body, "Content type undefined", new Object[0]));
            }
            return validationErrors;
        }
    }
}

