/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.validation;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import io.vrap.rmf.raml.model.types.Annotation;
import io.vrap.rmf.raml.model.types.AnyAnnotationType;
import io.vrap.rmf.raml.model.types.AnyType;
import io.vrap.rmf.raml.model.types.AnyTypeFacet;
import io.vrap.rmf.raml.model.types.ArrayType;
import io.vrap.rmf.raml.model.types.ArrayTypeFacet;
import io.vrap.rmf.raml.model.types.BuiltinType;
import io.vrap.rmf.raml.model.types.FileTypeFacet;
import io.vrap.rmf.raml.model.types.Instance;
import io.vrap.rmf.raml.model.types.IntegerTypeFacet;
import io.vrap.rmf.raml.model.types.IntersectionType;
import io.vrap.rmf.raml.model.types.NumberTypeFacet;
import io.vrap.rmf.raml.model.types.ObjectType;
import io.vrap.rmf.raml.model.types.Property;
import io.vrap.rmf.raml.model.types.StringInstance;
import io.vrap.rmf.raml.model.types.StringType;
import io.vrap.rmf.raml.model.types.StringTypeFacet;
import io.vrap.rmf.raml.model.types.TypedElement;
import io.vrap.rmf.raml.model.types.UnionType;
import io.vrap.rmf.raml.model.types.util.TypesSwitch;
import io.vrap.rmf.raml.validation.AbstractRamlValidator;
import io.vrap.rmf.raml.validation.InstanceValidator;
import io.vrap.rmf.raml.validation.ValidatingTypesSwitch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class TypesValidator
extends AbstractRamlValidator {
    private final TypeAndAnnoationTypeValidator typeAndAnnoationTypeValidator = new TypeAndAnnoationTypeValidator();
    private final List<ValidatingTypesSwitch> validators = Arrays.asList(new TypeResolutionValidator(), new TypeConsistencyCheck(), new AnnotationValidator(), new EnumFacetValidator(), new DefaultFacetValidator(), new ExamplesValidator(), new AnyTypeFacetValidator());

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List<Diagnostic> validationResults = this.validators.stream().flatMap(validator -> ((List)validator.doSwitch(eObject)).stream()).collect(Collectors.toList());
        validationResults.addAll((Collection)this.typeAndAnnoationTypeValidator.doSwitch(eObject));
        validationResults.forEach(arg_0 -> ((DiagnosticChain)diagnostics).add(arg_0));
        return validationResults.isEmpty();
    }

    private class AnyTypeFacetValidator
    extends ValidatingTypesSwitch {
        private AnyTypeFacetValidator() {
        }

        @Override
        public List<Diagnostic> caseAnyTypeFacet(AnyTypeFacet anyTypeFacet) {
            List<Object> validationResults;
            if (anyTypeFacet.getType() instanceof IntersectionType) {
                IntersectionType intersectionType = (IntersectionType)anyTypeFacet.getType();
                Set primitiveTypes = intersectionType.getAllOf().stream().map(EObject::eClass).map(BuiltinType::of).filter(Optional::isPresent).map(Optional::get).map(BuiltinType::getName).collect(Collectors.toSet());
                if (primitiveTypes.size() > 1) {
                    validationResults = new ArrayList<Diagnostic>();
                    String primitiveTypesAsString = Joiner.on((String)",").join(primitiveTypes);
                    validationResults.add(this.error(anyTypeFacet, "Intersection type has different primitive type [{0}]", new Object[]{primitiveTypesAsString}));
                } else {
                    validationResults = Collections.emptyList();
                }
            } else {
                validationResults = Collections.emptyList();
            }
            return validationResults;
        }
    }

    private class TypeResolutionValidator
    extends ValidatingTypesSwitch {
        private TypeResolutionValidator() {
        }

        @Override
        public List<Diagnostic> caseAnyType(AnyType anyType) {
            return this.validateTypeResolved(anyType);
        }

        @Override
        public List<Diagnostic> caseArrayType(ArrayType arrayType) {
            ArrayList<Diagnostic> results = new ArrayList<Diagnostic>();
            results.addAll(this.validateTypeResolved(arrayType));
            if (arrayType.getItems() != null && arrayType.getItems().eIsProxy()) {
                results.add(this.error(arrayType, "Items type {0} can''t be resolved", new Object[]{TypesValidator.this.getNameFromProxy(arrayType.getItems())}));
            }
            return results;
        }

        @Override
        public List<Diagnostic> caseTypedElement(TypedElement typedElement) {
            return this.validateTypeResolved(typedElement);
        }

        @Override
        public List<Diagnostic> caseUnionType(UnionType unionType) {
            ArrayList<Diagnostic> results = new ArrayList<Diagnostic>();
            results.addAll(this.validateTypeResolved(unionType));
            for (AnyType oneOf : unionType.getOneOf()) {
                if (!oneOf.eIsProxy()) continue;
                results.add(this.error(unionType, "Type ''{0}'' can''t be resolved", new Object[]{TypesValidator.this.getNameFromProxy(oneOf)}));
            }
            return results;
        }

        @Override
        public List<Diagnostic> caseIntersectionType(IntersectionType intersectionType) {
            ArrayList<Diagnostic> results = new ArrayList<Diagnostic>();
            results.addAll(this.validateTypeResolved(intersectionType));
            for (AnyType allOf : intersectionType.getAllOf()) {
                if (!allOf.eIsProxy()) continue;
                results.add(this.error(intersectionType, "Type ''{0}'' can''t be resolved", new Object[]{TypesValidator.this.getNameFromProxy(allOf)}));
            }
            return results;
        }

        private List<Diagnostic> validateTypeResolved(AnyTypeFacet anyType) {
            if (anyType.getType() != null && anyType.getType().eIsProxy()) {
                return Collections.singletonList(this.error(anyType, "Type ''{0}'' can''t be resolved", new Object[]{TypesValidator.this.getNameFromProxy(anyType.getType())}));
            }
            return Collections.emptyList();
        }

        private List<Diagnostic> validateTypeResolved(TypedElement typedElement) {
            if (typedElement.getType() != null && typedElement.getType().eIsProxy()) {
                return Collections.singletonList(this.error(typedElement, "Type ''{0}'' can''t be resolved", new Object[]{TypesValidator.this.getNameFromProxy(typedElement.getType())}));
            }
            return Collections.emptyList();
        }
    }

    static class TypeConsistencyCheck
    extends ValidatingTypesSwitch {
        TypeConsistencyCheck() {
        }

        @Override
        public List<Diagnostic> caseAnyTypeFacet(AnyTypeFacet anyTypeFacet) {
            AnyType superType = anyTypeFacet.getType();
            if (superType != null && anyTypeFacet.eClass() != superType.eClass()) {
                if (superType instanceof IntersectionType) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(this.error(anyTypeFacet, "Inconsistent types: Type ''{0}'' has eClass ''{1}'' while super type ''{2}'' has eClass ''{3}''", new Object[]{anyTypeFacet.getName(), anyTypeFacet.eClass().getName(), superType.getName(), superType.eClass().getName()}));
            }
            return Collections.emptyList();
        }
    }

    private class DefaultFacetValidator
    extends ValidatingTypesSwitch {
        private InstanceValidator instanceValidator = new InstanceValidator();

        private DefaultFacetValidator() {
        }

        @Override
        public List<Diagnostic> caseAnyType(AnyType anyType) {
            return this.validateDefault(anyType);
        }

        @Override
        public List<Diagnostic> caseAnyAnnotationType(AnyAnnotationType anyAnnotationType) {
            return this.validateDefault(anyAnnotationType);
        }

        private List<Diagnostic> validateDefault(AnyTypeFacet typeFacet) {
            List<Diagnostic> validationResults = Optional.ofNullable(typeFacet.getDefault()).map(value -> this.instanceValidator.validate((Instance)value, typeFacet)).orElse(Collections.emptyList());
            return validationResults;
        }
    }

    private class EnumFacetValidator
    extends ValidatingTypesSwitch {
        private InstanceValidator instanceValidator = new InstanceValidator();

        private EnumFacetValidator() {
        }

        @Override
        public List<Diagnostic> caseAnyType(AnyType anyType) {
            return this.validateEnum(anyType);
        }

        @Override
        public List<Diagnostic> caseAnyAnnotationType(AnyAnnotationType anyAnnotationType) {
            return this.validateEnum(anyAnnotationType);
        }

        private List<Diagnostic> validateEnum(AnyTypeFacet typeFacet) {
            ArrayList<Diagnostic> validationResults = new ArrayList<Diagnostic>();
            validationResults.addAll(typeFacet.getEnum().stream().flatMap(value -> this.instanceValidator.validate((Instance)value, typeFacet).stream()).collect(Collectors.toList()));
            if (validationResults.isEmpty()) {
                HashSet uniqueItems = new HashSet();
                Set duplicateValues = typeFacet.getEnum().stream().filter(value -> !uniqueItems.add(value.getValue())).collect(Collectors.toSet());
                if (duplicateValues.size() > 0) {
                    validationResults.add(this.error(typeFacet, "Enum facet contains duplicate values", new Object[0]));
                }
            }
            return validationResults;
        }
    }

    static class ExamplesValidator
    extends ValidatingTypesSwitch {
        private InstanceValidator instanceValidator = new InstanceValidator();

        ExamplesValidator() {
        }

        @Override
        public List<Diagnostic> caseAnyType(AnyType anyType) {
            List<Diagnostic> validationResults = anyType.getExamples().stream().filter(example -> example.getStrict() == null || example.getStrict().getValue() == null || example.getStrict().getValue() != false).flatMap(example -> this.instanceValidator.validate(example.getValue(), anyType).stream()).collect(Collectors.toList());
            return validationResults;
        }
    }

    private static class AnnotationValidator
    extends ValidatingTypesSwitch {
        private InstanceValidator instanceValidator = new InstanceValidator();

        private AnnotationValidator() {
        }

        @Override
        public List<Diagnostic> caseAnnotation(Annotation annotation) {
            return this.instanceValidator.validate(annotation);
        }
    }

    private class TypeAndAnnoationTypeValidator
    extends TypesSwitch<List<Diagnostic>> {
        private TypeAndAnnoationTypeValidator() {
        }

        @Override
        public List<Diagnostic> defaultCase(EObject object) {
            return Collections.emptyList();
        }

        @Override
        public List<Diagnostic> caseArrayTypeFacet(ArrayTypeFacet arrayType) {
            boolean rangeIsValid;
            ArrayList<Diagnostic> validationResults = new ArrayList<Diagnostic>();
            boolean bl = rangeIsValid = arrayType.getMinItems() == null || arrayType.getMaxItems() == null || arrayType.getMinItems() <= arrayType.getMaxItems();
            if (!rangeIsValid) {
                validationResults.add(TypesValidator.this.error(arrayType, "Facet 'minItems' ''{0}'' must be <= 'maxItems' ''{1}''", new Object[]{arrayType.getMinItems(), arrayType.getMaxItems()}));
            }
            return validationResults;
        }

        @Override
        public List<Diagnostic> caseNumberTypeFacet(NumberTypeFacet numberType) {
            return this.validateRange(numberType, numberType.getMinimum(), numberType.getMaximum());
        }

        @Override
        public List<Diagnostic> caseIntegerTypeFacet(IntegerTypeFacet integerType) {
            return this.validateRange(integerType, integerType.getMinimum(), integerType.getMaximum());
        }

        private <T> List<Diagnostic> validateRange(AnyTypeFacet typeFacet, Comparable<T> minimum, T maximum) {
            boolean rangeIsValid;
            ArrayList<Diagnostic> validationResults = new ArrayList<Diagnostic>();
            boolean bl = rangeIsValid = minimum == null || maximum == null || minimum.compareTo(maximum) <= 0;
            if (!rangeIsValid) {
                validationResults.add(TypesValidator.this.error(typeFacet, "Facet 'minimum' ''{0}'' must be <= 'maximum' ''{1}''", new Object[]{minimum, maximum}));
            }
            return validationResults;
        }

        @Override
        public List<Diagnostic> caseStringTypeFacet(StringTypeFacet stringType) {
            return this.validateLengthRange(stringType, stringType.getMinLength(), stringType.getMaxLength());
        }

        @Override
        public List<Diagnostic> caseFileTypeFacet(FileTypeFacet fileType) {
            return this.validateLengthRange(fileType, fileType.getMinLength(), fileType.getMaxLength());
        }

        private List<Diagnostic> validateLengthRange(AnyTypeFacet typeFacet, Integer minLength, Integer maxLength) {
            boolean rangeIsValid;
            ArrayList<Diagnostic> validationResults = new ArrayList<Diagnostic>();
            boolean bl = rangeIsValid = minLength == null || maxLength == null || minLength <= maxLength;
            if (!rangeIsValid) {
                validationResults.add(TypesValidator.this.error(typeFacet, "Facet 'minLength' ''{0}'' must be <= 'maxLength' ''{1}''", new Object[]{minLength, maxLength}));
            }
            return validationResults;
        }

        @Override
        public List<Diagnostic> caseProperty(Property property) {
            ArrayList<Diagnostic> validationResults = new ArrayList<Diagnostic>();
            if (Strings.isNullOrEmpty((String)property.getName())) {
                validationResults.add(TypesValidator.this.error(property, "Property must have a name", new Object[0]));
            } else if (property.getType() == null) {
                validationResults.add(TypesValidator.this.error(property, "Property must have a type", new Object[0]));
            }
            return validationResults;
        }

        @Override
        public List<Diagnostic> caseObjectType(ObjectType objectType) {
            ArrayList<Diagnostic> validationResults = new ArrayList<Diagnostic>();
            String discriminator = objectType.getDiscriminator();
            if (discriminator != null) {
                Property discriminatorProperty = objectType.getProperty(discriminator);
                if (discriminatorProperty == null) {
                    validationResults.add(TypesValidator.this.error(objectType, "Type with discriminator ''{0}'' has to define a property for it", new Object[]{discriminator}));
                } else if (!(discriminatorProperty.getType() instanceof StringType)) {
                    validationResults.add(TypesValidator.this.error(objectType, "Discriminator property ''{0}'' must be of type 'string'", new Object[]{discriminator}));
                } else {
                    HashSet<String> discriminatorValues = new HashSet<String>();
                    discriminatorValues.add(objectType.discriminatorValueOrDefault());
                    this.validateDiscriminatorValueUniqueness(objectType, discriminatorValues, validationResults);
                    this.validateDiscriminatorValueEnum(objectType, discriminatorProperty, validationResults);
                }
            }
            return validationResults;
        }

        private void validateDiscriminatorValueUniqueness(ObjectType objectType, Set<String> discriminatorValues, List<Diagnostic> validationResults) {
            List properSubTypes = objectType.getSubTypes().stream().filter(ObjectType.class::isInstance).map(ObjectType.class::cast).filter(o -> !o.isInlineType()).collect(Collectors.toList());
            for (ObjectType subType : properSubTypes) {
                String discriminatorValue = subType.discriminatorValueOrDefault();
                if (discriminatorValues.contains(discriminatorValue)) {
                    validationResults.add(TypesValidator.this.error(subType, "Duplicate discriminator value ''{0}'' found", new Object[]{discriminatorValue}));
                } else {
                    discriminatorValues.add(discriminatorValue);
                }
                this.validateDiscriminatorValueUniqueness(subType, discriminatorValues, validationResults);
            }
        }

        private void validateDiscriminatorValueEnum(ObjectType objectType, Property discriminatorProperty, List<Diagnostic> validationResults) {
            AnyType discriminatorPropertyType = discriminatorProperty.getType();
            if (discriminatorPropertyType.isInlineType()) {
                discriminatorPropertyType = discriminatorPropertyType.getType();
            }
            if (discriminatorPropertyType.getEnum().isEmpty()) {
                return;
            }
            List properSubTypes = objectType.getSubTypes().stream().filter(ObjectType.class::isInstance).map(ObjectType.class::cast).filter(o -> !o.isInlineType()).collect(Collectors.toList());
            Set enumValues = discriminatorPropertyType.getEnum().stream().filter(StringInstance.class::isInstance).map(StringInstance.class::cast).map(StringInstance::getValue).collect(Collectors.toSet());
            for (ObjectType subType : properSubTypes) {
                String discriminatorValue = subType.discriminatorValueOrDefault();
                if (!enumValues.contains(discriminatorValue)) {
                    validationResults.add(TypesValidator.this.error(subType, "Discriminator value ''{0}'' not found in enum of type ''{1}''", new Object[]{discriminatorValue, discriminatorPropertyType.getName()}));
                }
                this.validateDiscriminatorValueEnum(subType, discriminatorProperty, validationResults);
            }
        }
    }
}

