/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.raml.validation;

import io.vrap.rmf.nodes.antlr.NodeToken;
import io.vrap.rmf.nodes.antlr.NodeTokenProvider;
import io.vrap.rmf.raml.validation.DiagnosticsCreator;
import io.vrap.rmf.raml.validation.Source;
import java.text.MessageFormat;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class Violation {
    private final Class<DiagnosticsCreator> rule;
    private final EObject object;
    private final String messagePattern;
    private final Object[] messageArgs;
    private final Integer severity;
    private final Source source;
    private final String message;

    public Violation(Integer severity, Class<DiagnosticsCreator> rule, EObject object, String messagePattern, Object ... messageArgs) {
        this.rule = rule;
        this.object = object;
        this.messagePattern = messagePattern;
        this.messageArgs = messageArgs;
        this.severity = severity;
        this.source = this.getSource(object);
        this.message = MessageFormat.format(messagePattern, messageArgs);
    }

    private Source getSource(EObject object) {
        NodeTokenProvider nodeTokenProvider = (NodeTokenProvider)EcoreUtil.getExistingAdapter((Notifier)object, NodeTokenProvider.class);
        if (nodeTokenProvider != null) {
            NodeToken nodeToken = nodeTokenProvider.getStart();
            return new Source(nodeToken.getLocation(), nodeToken.getLine(), nodeToken.getCharPositionInLine());
        }
        return null;
    }

    public Class<DiagnosticsCreator> getRule() {
        return this.rule;
    }

    public EObject getObject() {
        return this.object;
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }

    public Object[] getMessageArgs() {
        return this.messageArgs;
    }

    public Integer getSeverity() {
        return this.severity;
    }

    public Source getSource() {
        return this.source;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetailMessage() {
        return MessageFormat.format("{0}: {1}", this.rule.getSimpleName(), this.message);
    }
}

