/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.http.asynchttp;

import com.commercetools.http.asynchttp.BuilderOptions;
import com.commercetools.http.asynchttp.ResponseAsyncCompletionHandler;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.AsciiString;
import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.HttpClientBase;
import io.vrap.rmf.base.client.VrapHttpClient;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.filter.RequestFilter;
import org.asynchttpclient.filter.ThrottleRequestFilter;

public class CtAsyncHttpClient
extends HttpClientBase
implements VrapHttpClient,
AutoCloseable {
    public static final int MAX_REQUESTS = 64;
    private final AsyncHttpClient asyncHttpClient;
    private final Supplier<DefaultAsyncHttpClientConfig.Builder> clientBuilder = CtAsyncHttpClient::createClientBuilder;

    public static DefaultAsyncHttpClientConfig.Builder createClientBuilder() {
        return new DefaultAsyncHttpClientConfig.Builder().setEnabledProtocols(new String[]{"TLSv1.3", "TLSv1.2"}).setReadTimeout(121000).setRequestTimeout(121000);
    }

    public CtAsyncHttpClient() {
        this.asyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)this.clientBuilder.get().addRequestFilter((RequestFilter)new ThrottleRequestFilter(64)).build());
    }

    public CtAsyncHttpClient(int maxConnections) {
        this.asyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)this.clientBuilder.get().addRequestFilter((RequestFilter)new ThrottleRequestFilter(maxConnections)).build());
    }

    public CtAsyncHttpClient(BuilderOptions options) {
        this.asyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)options.plus(this.clientBuilder.get()).build());
    }

    public CtAsyncHttpClient(int maxConnections, BuilderOptions options) {
        this.asyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)options.plus(this.clientBuilder.get().addRequestFilter((RequestFilter)new ThrottleRequestFilter(maxConnections))).build());
    }

    public CtAsyncHttpClient(Supplier<DefaultAsyncHttpClientConfig.Builder> builderSupplier) {
        this.asyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)builderSupplier.get().build());
    }

    public CtAsyncHttpClient(ExecutorService executor) {
        super(executor);
        this.asyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)this.clientBuilder.get().build());
    }

    public CtAsyncHttpClient(ExecutorService executor, int maxConnections) {
        super(executor);
        this.asyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)this.clientBuilder.get().addRequestFilter((RequestFilter)new ThrottleRequestFilter(maxConnections)).build());
    }

    public CtAsyncHttpClient(ExecutorService executor, BuilderOptions options) {
        super(executor);
        this.asyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)options.plus(this.clientBuilder.get()).build());
    }

    public CtAsyncHttpClient(ExecutorService executor, int maxConnections, BuilderOptions options) {
        super(executor);
        this.asyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)options.plus(this.clientBuilder.get().addRequestFilter((RequestFilter)new ThrottleRequestFilter(maxConnections))).build());
    }

    public CtAsyncHttpClient(ExecutorService executor, Supplier<DefaultAsyncHttpClientConfig.Builder> builderSupplier) {
        super(executor);
        this.asyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)builderSupplier.get().build());
    }

    public CompletableFuture<ApiHttpResponse<byte[]>> execute(ApiHttpRequest httpRequest) {
        Request request = this.asAhcRequest(httpRequest);
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        this.asyncHttpClient.executeRequest(request, (AsyncHandler)new ResponseAsyncCompletionHandler(future));
        return future.thenApplyAsync(this::convert, this.executor());
    }

    private ApiHttpResponse<byte[]> convert(Response response) {
        byte[] responseBodyAsBytes = this.getResponseBodyAsBytes(response);
        int statusCode = response.getStatusCode();
        ApiHttpHeaders headers = new ApiHttpHeaders(response.getHeaders().entries());
        return new ApiHttpResponse(statusCode, headers, (Object)responseBodyAsBytes, response.getStatusText());
    }

    private byte[] getResponseBodyAsBytes(Response response) {
        return response.getResponseBodyAsBytes();
    }

    private Request asAhcRequest(ApiHttpRequest request) {
        RequestBuilder builder = (RequestBuilder)((RequestBuilder)new RequestBuilder().setUrl(request.getUrl().toString())).setMethod(request.getMethod().toString());
        request.getHeaders().getHeaders().forEach(entry -> builder.addHeader((CharSequence)entry.getKey(), (String)entry.getValue()));
        Optional.ofNullable(request.getBody()).ifPresent(body -> {
            builder.setBody(body);
            AsciiString mediaType = HttpHeaderValues.APPLICATION_JSON;
            if (request.getHeaders().getHeaders().stream().anyMatch(s -> ((String)s.getKey()).equalsIgnoreCase("Content-Type"))) {
                mediaType = AsciiString.of((CharSequence)Objects.requireNonNull(request.getHeaders().getFirst("Content-Type")));
            }
            builder.setHeader((CharSequence)"Content-Type", (Object)mediaType);
        });
        return builder.build();
    }

    public void closeDelegate() throws Exception {
        this.asyncHttpClient.close();
    }
}

