/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api;

import com.commercetools.api.models.graph_ql.GraphQLError;
import com.commercetools.graphql.api.GraphQLData;
import com.commercetools.graphql.api.GraphQLDataResponseBuilder;
import com.commercetools.graphql.api.GraphQLDataResponseImpl;
import com.commercetools.graphql.api.GraphQLRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonDeserialize(as=GraphQLDataResponseImpl.class)
public interface GraphQLDataResponse {
    @JsonProperty(value="data")
    public GraphQLData getData();

    @Valid
    @JsonProperty(value="errors")
    public List<GraphQLError> getErrors();

    public void setData(GraphQLData var1);

    @JsonIgnore
    public void setErrors(GraphQLError ... var1);

    public void setErrors(List<GraphQLError> var1);

    default public <T> T getData(GraphQLRequest<T> request) {
        return request.getDataMapper().apply(this.getData());
    }

    public static GraphQLDataResponse of() {
        return new GraphQLDataResponseImpl();
    }

    public static GraphQLDataResponse of(GraphQLDataResponse template) {
        GraphQLDataResponseImpl instance = new GraphQLDataResponseImpl();
        instance.setData(template.getData());
        instance.setErrors(template.getErrors());
        return instance;
    }

    @Nullable
    public static GraphQLDataResponse deepCopy(@Nullable GraphQLDataResponse template) {
        if (template == null) {
            return null;
        }
        GraphQLDataResponseImpl instance = new GraphQLDataResponseImpl();
        instance.setData(template.getData());
        instance.setErrors((List<GraphQLError>)Optional.ofNullable(template.getErrors()).map(t -> t.stream().map(GraphQLError::deepCopy).collect(Collectors.toList())).orElse(null));
        return instance;
    }

    public static GraphQLDataResponseBuilder builder() {
        return GraphQLDataResponseBuilder.of();
    }

    public static GraphQLDataResponseBuilder builder(GraphQLDataResponse template) {
        return GraphQLDataResponseBuilder.of(template);
    }

    default public <T> T withGraphQLDataResponse(Function<GraphQLDataResponse, T> helper) {
        return helper.apply(this);
    }

    public static TypeReference<GraphQLDataResponse> typeReference() {
        return new TypeReference<GraphQLDataResponse>(){

            public String toString() {
                return "TypeReference<GraphQLDataResponse>";
            }
        };
    }
}

