/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api;

import com.commercetools.api.models.graph_ql.GraphQLError;
import com.commercetools.graphql.api.GraphQLData;
import com.commercetools.graphql.api.GraphQLDataResponse;
import com.commercetools.graphql.api.GraphQLRequest;
import java.util.List;
import java.util.function.Function;

public class GraphQLResponse<T> {
    private final GraphQLDataResponse response;
    private final Function<GraphQLData, T> mapper;

    public GraphQLResponse(GraphQLDataResponse response, Function<GraphQLData, T> mapper) {
        this.response = response;
        this.mapper = mapper;
    }

    public T getData() {
        return this.mapper.apply(this.response.getData());
    }

    public List<GraphQLError> getErrors() {
        return this.response.getErrors();
    }

    public static <T> GraphQLResponse<T> of(GraphQLDataResponse response, GraphQLRequest<T> request) {
        return new GraphQLResponse<T>(response, request.getDataMapper());
    }
}

