/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Address;
import com.commercetools.graphql.api.types.CustomFieldsType;
import com.commercetools.graphql.api.types.DeliveryItem;
import com.commercetools.graphql.api.types.Parcel;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public class Delivery {
    private String id;
    private String key;
    private OffsetDateTime createdAt;
    private List<DeliveryItem> items;
    private List<Parcel> parcels;
    private Address address;
    private CustomFieldsType custom;

    public Delivery() {
    }

    public Delivery(String id, String key, OffsetDateTime createdAt, List<DeliveryItem> items, List<Parcel> parcels, Address address, CustomFieldsType custom) {
        this.id = id;
        this.key = key;
        this.createdAt = createdAt;
        this.items = items;
        this.parcels = parcels;
        this.address = address;
        this.custom = custom;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public List<DeliveryItem> getItems() {
        return this.items;
    }

    public void setItems(List<DeliveryItem> items) {
        this.items = items;
    }

    public List<Parcel> getParcels() {
        return this.parcels;
    }

    public void setParcels(List<Parcel> parcels) {
        this.parcels = parcels;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public CustomFieldsType getCustom() {
        return this.custom;
    }

    public void setCustom(CustomFieldsType custom) {
        this.custom = custom;
    }

    public String toString() {
        return "Delivery{id='" + this.id + "', key='" + this.key + "', createdAt='" + this.createdAt + "', items='" + this.items + "', parcels='" + this.parcels + "', address='" + this.address + "', custom='" + this.custom + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Delivery that = (Delivery)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.key, that.key) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.items, that.items) && Objects.equals(this.parcels, that.parcels) && Objects.equals(this.address, that.address) && Objects.equals(this.custom, that.custom);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.key, this.createdAt, this.items, this.parcels, this.address, this.custom);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private String key;
        private OffsetDateTime createdAt;
        private List<DeliveryItem> items;
        private List<Parcel> parcels;
        private Address address;
        private CustomFieldsType custom;

        public Delivery build() {
            Delivery result = new Delivery();
            result.id = this.id;
            result.key = this.key;
            result.createdAt = this.createdAt;
            result.items = this.items;
            result.parcels = this.parcels;
            result.address = this.address;
            result.custom = this.custom;
            return result;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder items(List<DeliveryItem> items) {
            this.items = items;
            return this;
        }

        public Builder parcels(List<Parcel> parcels) {
            this.parcels = parcels;
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public Builder custom(CustomFieldsType custom) {
            this.custom = custom;
            return this;
        }
    }
}

