/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Address;
import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.OrderMessagePayload;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class DeliveryAddressSet
implements MessagePayload,
OrderMessagePayload {
    private String deliveryId;
    private Address address;
    private Address oldAddress;
    private String shippingKey;
    private String type;

    public DeliveryAddressSet() {
    }

    public DeliveryAddressSet(String deliveryId, Address address, Address oldAddress, String shippingKey, String type) {
        this.deliveryId = deliveryId;
        this.address = address;
        this.oldAddress = oldAddress;
        this.shippingKey = shippingKey;
        this.type = type;
    }

    public String getDeliveryId() {
        return this.deliveryId;
    }

    public void setDeliveryId(String deliveryId) {
        this.deliveryId = deliveryId;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Address getOldAddress() {
        return this.oldAddress;
    }

    public void setOldAddress(Address oldAddress) {
        this.oldAddress = oldAddress;
    }

    public String getShippingKey() {
        return this.shippingKey;
    }

    public void setShippingKey(String shippingKey) {
        this.shippingKey = shippingKey;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "DeliveryAddressSet{deliveryId='" + this.deliveryId + "', address='" + this.address + "', oldAddress='" + this.oldAddress + "', shippingKey='" + this.shippingKey + "', type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeliveryAddressSet that = (DeliveryAddressSet)o;
        return Objects.equals(this.deliveryId, that.deliveryId) && Objects.equals(this.address, that.address) && Objects.equals(this.oldAddress, that.oldAddress) && Objects.equals(this.shippingKey, that.shippingKey) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.deliveryId, this.address, this.oldAddress, this.shippingKey, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String deliveryId;
        private Address address;
        private Address oldAddress;
        private String shippingKey;
        private String type;

        public DeliveryAddressSet build() {
            DeliveryAddressSet result = new DeliveryAddressSet();
            result.deliveryId = this.deliveryId;
            result.address = this.address;
            result.oldAddress = this.oldAddress;
            result.shippingKey = this.shippingKey;
            result.type = this.type;
            return result;
        }

        public Builder deliveryId(String deliveryId) {
            this.deliveryId = deliveryId;
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public Builder oldAddress(Address oldAddress) {
            this.oldAddress = oldAddress;
            return this;
        }

        public Builder shippingKey(String shippingKey) {
            this.shippingKey = shippingKey;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

