/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import java.util.List;
import java.util.Objects;

public class GeometryInput {
    private String type;
    private List<Double> coordinates;

    public GeometryInput() {
    }

    public GeometryInput(String type, List<Double> coordinates) {
        this.type = type;
        this.coordinates = coordinates;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<Double> getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(List<Double> coordinates) {
        this.coordinates = coordinates;
    }

    public String toString() {
        return "GeometryInput{type='" + this.type + "', coordinates='" + this.coordinates + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeometryInput that = (GeometryInput)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.coordinates, that.coordinates);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.coordinates);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String type;
        private List<Double> coordinates;

        public GeometryInput build() {
            GeometryInput result = new GeometryInput();
            result.type = this.type;
            result.coordinates = this.coordinates;
            return result;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder coordinates(List<Double> coordinates) {
            this.coordinates = coordinates;
            return this;
        }
    }
}

