/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.DimensionsInput;
import java.util.Objects;

public class ImageInput {
    private String url;
    private String label;
    private DimensionsInput dimensions;

    public ImageInput() {
    }

    public ImageInput(String url, String label, DimensionsInput dimensions) {
        this.url = url;
        this.label = label;
        this.dimensions = dimensions;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public DimensionsInput getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(DimensionsInput dimensions) {
        this.dimensions = dimensions;
    }

    public String toString() {
        return "ImageInput{url='" + this.url + "', label='" + this.label + "', dimensions='" + this.dimensions + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageInput that = (ImageInput)o;
        return Objects.equals(this.url, that.url) && Objects.equals(this.label, that.label) && Objects.equals(this.dimensions, that.dimensions);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.label, this.dimensions);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String url;
        private String label;
        private DimensionsInput dimensions;

        public ImageInput build() {
            ImageInput result = new ImageInput();
            result.url = this.url;
            result.label = this.label;
            result.dimensions = this.dimensions;
            return result;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder dimensions(DimensionsInput dimensions) {
            this.dimensions = dimensions;
            return this;
        }
    }
}

