/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.OrderMessagePayload;
import com.commercetools.graphql.api.types.Reference;
import com.commercetools.graphql.api.types.State;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class LineItemStateTransition
implements MessagePayload,
OrderMessagePayload {
    private String lineItemId;
    private String lineItemKey;
    private OffsetDateTime transitionDate;
    private Long quantity;
    private State fromState;
    private State toState;
    private Reference fromStateRef;
    private Reference toStateRef;
    private String type;

    public LineItemStateTransition() {
    }

    public LineItemStateTransition(String lineItemId, String lineItemKey, OffsetDateTime transitionDate, Long quantity, State fromState, State toState, Reference fromStateRef, Reference toStateRef, String type) {
        this.lineItemId = lineItemId;
        this.lineItemKey = lineItemKey;
        this.transitionDate = transitionDate;
        this.quantity = quantity;
        this.fromState = fromState;
        this.toState = toState;
        this.fromStateRef = fromStateRef;
        this.toStateRef = toStateRef;
        this.type = type;
    }

    public String getLineItemId() {
        return this.lineItemId;
    }

    public void setLineItemId(String lineItemId) {
        this.lineItemId = lineItemId;
    }

    public String getLineItemKey() {
        return this.lineItemKey;
    }

    public void setLineItemKey(String lineItemKey) {
        this.lineItemKey = lineItemKey;
    }

    public OffsetDateTime getTransitionDate() {
        return this.transitionDate;
    }

    public void setTransitionDate(OffsetDateTime transitionDate) {
        this.transitionDate = transitionDate;
    }

    public Long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    public State getFromState() {
        return this.fromState;
    }

    public void setFromState(State fromState) {
        this.fromState = fromState;
    }

    public State getToState() {
        return this.toState;
    }

    public void setToState(State toState) {
        this.toState = toState;
    }

    public Reference getFromStateRef() {
        return this.fromStateRef;
    }

    public void setFromStateRef(Reference fromStateRef) {
        this.fromStateRef = fromStateRef;
    }

    public Reference getToStateRef() {
        return this.toStateRef;
    }

    public void setToStateRef(Reference toStateRef) {
        this.toStateRef = toStateRef;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "LineItemStateTransition{lineItemId='" + this.lineItemId + "', lineItemKey='" + this.lineItemKey + "', transitionDate='" + this.transitionDate + "', quantity='" + this.quantity + "', fromState='" + this.fromState + "', toState='" + this.toState + "', fromStateRef='" + this.fromStateRef + "', toStateRef='" + this.toStateRef + "', type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineItemStateTransition that = (LineItemStateTransition)o;
        return Objects.equals(this.lineItemId, that.lineItemId) && Objects.equals(this.lineItemKey, that.lineItemKey) && Objects.equals(this.transitionDate, that.transitionDate) && Objects.equals(this.quantity, that.quantity) && Objects.equals(this.fromState, that.fromState) && Objects.equals(this.toState, that.toState) && Objects.equals(this.fromStateRef, that.fromStateRef) && Objects.equals(this.toStateRef, that.toStateRef) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.lineItemId, this.lineItemKey, this.transitionDate, this.quantity, this.fromState, this.toState, this.fromStateRef, this.toStateRef, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String lineItemId;
        private String lineItemKey;
        private OffsetDateTime transitionDate;
        private Long quantity;
        private State fromState;
        private State toState;
        private Reference fromStateRef;
        private Reference toStateRef;
        private String type;

        public LineItemStateTransition build() {
            LineItemStateTransition result = new LineItemStateTransition();
            result.lineItemId = this.lineItemId;
            result.lineItemKey = this.lineItemKey;
            result.transitionDate = this.transitionDate;
            result.quantity = this.quantity;
            result.fromState = this.fromState;
            result.toState = this.toState;
            result.fromStateRef = this.fromStateRef;
            result.toStateRef = this.toStateRef;
            result.type = this.type;
            return result;
        }

        public Builder lineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
            return this;
        }

        public Builder lineItemKey(String lineItemKey) {
            this.lineItemKey = lineItemKey;
            return this;
        }

        public Builder transitionDate(OffsetDateTime transitionDate) {
            this.transitionDate = transitionDate;
            return this;
        }

        public Builder quantity(Long quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder fromState(State fromState) {
            this.fromState = fromState;
            return this;
        }

        public Builder toState(State toState) {
            this.toState = toState;
            return this;
        }

        public Builder fromStateRef(Reference fromStateRef) {
            this.fromStateRef = fromStateRef;
            return this;
        }

        public Builder toStateRef(Reference toStateRef) {
            this.toStateRef = toStateRef;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

