/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Attribute;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Currency;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class MoneyAttribute
implements Attribute {
    private Long centAmount;
    private Currency currencyCode;
    private String name;

    public MoneyAttribute() {
    }

    public MoneyAttribute(Long centAmount, Currency currencyCode, String name) {
        this.centAmount = centAmount;
        this.currencyCode = currencyCode;
        this.name = name;
    }

    public Long getCentAmount() {
        return this.centAmount;
    }

    public void setCentAmount(Long centAmount) {
        this.centAmount = centAmount;
    }

    public Currency getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(Currency currencyCode) {
        this.currencyCode = currencyCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "MoneyAttribute{centAmount='" + this.centAmount + "', currencyCode='" + this.currencyCode + "', name='" + this.name + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MoneyAttribute that = (MoneyAttribute)o;
        return Objects.equals(this.centAmount, that.centAmount) && Objects.equals(this.currencyCode, that.currencyCode) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.centAmount, this.currencyCode, this.name);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Long centAmount;
        private Currency currencyCode;
        private String name;

        public MoneyAttribute build() {
            MoneyAttribute result = new MoneyAttribute();
            result.centAmount = this.centAmount;
            result.currencyCode = this.currencyCode;
            result.name = this.name;
            return result;
        }

        public Builder centAmount(Long centAmount) {
            this.centAmount = centAmount;
            return this;
        }

        public Builder currencyCode(Currency currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }
    }
}

