/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.CustomField;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class NumberField
implements CustomField {
    private Double value;
    private String name;

    public NumberField() {
    }

    public NumberField(Double value, String name) {
        this.value = value;
        this.name = name;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "NumberField{value='" + this.value + "', name='" + this.name + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberField that = (NumberField)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.name);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Double value;
        private String name;

        public NumberField build() {
            NumberField result = new NumberField();
            result.value = this.value;
            result.name = this.name;
            return result;
        }

        public Builder value(Double value) {
            this.value = value;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }
    }
}

