/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.CustomFieldsDraft;
import com.commercetools.graphql.api.types.OrderState;
import com.commercetools.graphql.api.types.PaymentState;
import com.commercetools.graphql.api.types.ResourceIdentifierInput;
import com.commercetools.graphql.api.types.ShipmentState;
import java.util.Objects;

public class OrderQuoteCommand {
    private ResourceIdentifierInput quote;
    private Long version;
    private Boolean quoteStateToAccepted = false;
    private PaymentState paymentState;
    private OrderState orderState;
    private ResourceIdentifierInput state;
    private ShipmentState shipmentState;
    private String orderNumber;
    private CustomFieldsDraft custom;

    public OrderQuoteCommand() {
    }

    public OrderQuoteCommand(ResourceIdentifierInput quote, Long version, Boolean quoteStateToAccepted, PaymentState paymentState, OrderState orderState, ResourceIdentifierInput state, ShipmentState shipmentState, String orderNumber, CustomFieldsDraft custom) {
        this.quote = quote;
        this.version = version;
        this.quoteStateToAccepted = quoteStateToAccepted;
        this.paymentState = paymentState;
        this.orderState = orderState;
        this.state = state;
        this.shipmentState = shipmentState;
        this.orderNumber = orderNumber;
        this.custom = custom;
    }

    public ResourceIdentifierInput getQuote() {
        return this.quote;
    }

    public void setQuote(ResourceIdentifierInput quote) {
        this.quote = quote;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Boolean getQuoteStateToAccepted() {
        return this.quoteStateToAccepted;
    }

    public void setQuoteStateToAccepted(Boolean quoteStateToAccepted) {
        this.quoteStateToAccepted = quoteStateToAccepted;
    }

    public PaymentState getPaymentState() {
        return this.paymentState;
    }

    public void setPaymentState(PaymentState paymentState) {
        this.paymentState = paymentState;
    }

    public OrderState getOrderState() {
        return this.orderState;
    }

    public void setOrderState(OrderState orderState) {
        this.orderState = orderState;
    }

    public ResourceIdentifierInput getState() {
        return this.state;
    }

    public void setState(ResourceIdentifierInput state) {
        this.state = state;
    }

    public ShipmentState getShipmentState() {
        return this.shipmentState;
    }

    public void setShipmentState(ShipmentState shipmentState) {
        this.shipmentState = shipmentState;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public CustomFieldsDraft getCustom() {
        return this.custom;
    }

    public void setCustom(CustomFieldsDraft custom) {
        this.custom = custom;
    }

    public String toString() {
        return "OrderQuoteCommand{quote='" + this.quote + "', version='" + this.version + "', quoteStateToAccepted='" + this.quoteStateToAccepted + "', paymentState='" + (Object)((Object)this.paymentState) + "', orderState='" + (Object)((Object)this.orderState) + "', state='" + this.state + "', shipmentState='" + (Object)((Object)this.shipmentState) + "', orderNumber='" + this.orderNumber + "', custom='" + this.custom + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderQuoteCommand that = (OrderQuoteCommand)o;
        return Objects.equals(this.quote, that.quote) && Objects.equals(this.version, that.version) && Objects.equals(this.quoteStateToAccepted, that.quoteStateToAccepted) && Objects.equals((Object)this.paymentState, (Object)that.paymentState) && Objects.equals((Object)this.orderState, (Object)that.orderState) && Objects.equals(this.state, that.state) && Objects.equals((Object)this.shipmentState, (Object)that.shipmentState) && Objects.equals(this.orderNumber, that.orderNumber) && Objects.equals(this.custom, that.custom);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.quote, this.version, this.quoteStateToAccepted, this.paymentState, this.orderState, this.state, this.shipmentState, this.orderNumber, this.custom});
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ResourceIdentifierInput quote;
        private Long version;
        private Boolean quoteStateToAccepted = false;
        private PaymentState paymentState;
        private OrderState orderState;
        private ResourceIdentifierInput state;
        private ShipmentState shipmentState;
        private String orderNumber;
        private CustomFieldsDraft custom;

        public OrderQuoteCommand build() {
            OrderQuoteCommand result = new OrderQuoteCommand();
            result.quote = this.quote;
            result.version = this.version;
            result.quoteStateToAccepted = this.quoteStateToAccepted;
            result.paymentState = this.paymentState;
            result.orderState = this.orderState;
            result.state = this.state;
            result.shipmentState = this.shipmentState;
            result.orderNumber = this.orderNumber;
            result.custom = this.custom;
            return result;
        }

        public Builder quote(ResourceIdentifierInput quote) {
            this.quote = quote;
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Builder quoteStateToAccepted(Boolean quoteStateToAccepted) {
            this.quoteStateToAccepted = quoteStateToAccepted;
            return this;
        }

        public Builder paymentState(PaymentState paymentState) {
            this.paymentState = paymentState;
            return this;
        }

        public Builder orderState(OrderState orderState) {
            this.orderState = orderState;
            return this;
        }

        public Builder state(ResourceIdentifierInput state) {
            this.state = state;
            return this;
        }

        public Builder shipmentState(ShipmentState shipmentState) {
            this.shipmentState = shipmentState;
            return this;
        }

        public Builder orderNumber(String orderNumber) {
            this.orderNumber = orderNumber;
            return this;
        }

        public Builder custom(CustomFieldsDraft custom) {
            this.custom = custom;
            return this;
        }
    }
}

