/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.OrderMessagePayload;
import com.commercetools.graphql.api.types.OrderState;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class OrderStateChanged
implements MessagePayload,
OrderMessagePayload {
    private String orderId;
    private OrderState orderState;
    private OrderState oldOrderState;
    private String type;

    public OrderStateChanged() {
    }

    public OrderStateChanged(String orderId, OrderState orderState, OrderState oldOrderState, String type) {
        this.orderId = orderId;
        this.orderState = orderState;
        this.oldOrderState = oldOrderState;
        this.type = type;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public OrderState getOrderState() {
        return this.orderState;
    }

    public void setOrderState(OrderState orderState) {
        this.orderState = orderState;
    }

    public OrderState getOldOrderState() {
        return this.oldOrderState;
    }

    public void setOldOrderState(OrderState oldOrderState) {
        this.oldOrderState = oldOrderState;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "OrderStateChanged{orderId='" + this.orderId + "', orderState='" + (Object)((Object)this.orderState) + "', oldOrderState='" + (Object)((Object)this.oldOrderState) + "', type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderStateChanged that = (OrderStateChanged)o;
        return Objects.equals(this.orderId, that.orderId) && Objects.equals((Object)this.orderState, (Object)that.orderState) && Objects.equals((Object)this.oldOrderState, (Object)that.oldOrderState) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.orderId, this.orderState, this.oldOrderState, this.type});
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String orderId;
        private OrderState orderState;
        private OrderState oldOrderState;
        private String type;

        public OrderStateChanged build() {
            OrderStateChanged result = new OrderStateChanged();
            result.orderId = this.orderId;
            result.orderState = this.orderState;
            result.oldOrderState = this.oldOrderState;
            result.type = this.type;
            return result;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder orderState(OrderState orderState) {
            this.orderState = orderState;
            return this;
        }

        public Builder oldOrderState(OrderState oldOrderState) {
            this.oldOrderState = oldOrderState;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

