/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.CustomFieldsDraft;
import com.commercetools.graphql.api.types.DeliveryItemDraftType;
import com.commercetools.graphql.api.types.ParcelMeasurementsDraftType;
import com.commercetools.graphql.api.types.TrackingDataDraftType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ParcelDataDraftType {
    private String key;
    private ParcelMeasurementsDraftType measurements;
    private TrackingDataDraftType trackingData;
    private List<DeliveryItemDraftType> items = Collections.emptyList();
    private CustomFieldsDraft custom;

    public ParcelDataDraftType() {
    }

    public ParcelDataDraftType(String key, ParcelMeasurementsDraftType measurements, TrackingDataDraftType trackingData, List<DeliveryItemDraftType> items, CustomFieldsDraft custom) {
        this.key = key;
        this.measurements = measurements;
        this.trackingData = trackingData;
        this.items = items;
        this.custom = custom;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ParcelMeasurementsDraftType getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(ParcelMeasurementsDraftType measurements) {
        this.measurements = measurements;
    }

    public TrackingDataDraftType getTrackingData() {
        return this.trackingData;
    }

    public void setTrackingData(TrackingDataDraftType trackingData) {
        this.trackingData = trackingData;
    }

    public List<DeliveryItemDraftType> getItems() {
        return this.items;
    }

    public void setItems(List<DeliveryItemDraftType> items) {
        this.items = items;
    }

    public CustomFieldsDraft getCustom() {
        return this.custom;
    }

    public void setCustom(CustomFieldsDraft custom) {
        this.custom = custom;
    }

    public String toString() {
        return "ParcelDataDraftType{key='" + this.key + "', measurements='" + this.measurements + "', trackingData='" + this.trackingData + "', items='" + this.items + "', custom='" + this.custom + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParcelDataDraftType that = (ParcelDataDraftType)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.measurements, that.measurements) && Objects.equals(this.trackingData, that.trackingData) && Objects.equals(this.items, that.items) && Objects.equals(this.custom, that.custom);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.measurements, this.trackingData, this.items, this.custom);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String key;
        private ParcelMeasurementsDraftType measurements;
        private TrackingDataDraftType trackingData;
        private List<DeliveryItemDraftType> items = Collections.emptyList();
        private CustomFieldsDraft custom;

        public ParcelDataDraftType build() {
            ParcelDataDraftType result = new ParcelDataDraftType();
            result.key = this.key;
            result.measurements = this.measurements;
            result.trackingData = this.trackingData;
            result.items = this.items;
            result.custom = this.custom;
            return result;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder measurements(ParcelMeasurementsDraftType measurements) {
            this.measurements = measurements;
            return this;
        }

        public Builder trackingData(TrackingDataDraftType trackingData) {
            this.trackingData = trackingData;
            return this;
        }

        public Builder items(List<DeliveryItemDraftType> items) {
            this.items = items;
            return this;
        }

        public Builder custom(CustomFieldsDraft custom) {
            this.custom = custom;
            return this;
        }
    }
}

