/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.MessagePayload;
import com.commercetools.graphql.api.types.OrderMessagePayload;
import com.commercetools.graphql.api.types.TrackingData;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class ParcelTrackingDataUpdated
implements MessagePayload,
OrderMessagePayload {
    private String deliveryId;
    private String parcelId;
    private TrackingData trackingData;
    private String shippingKey;
    private String type;

    public ParcelTrackingDataUpdated() {
    }

    public ParcelTrackingDataUpdated(String deliveryId, String parcelId, TrackingData trackingData, String shippingKey, String type) {
        this.deliveryId = deliveryId;
        this.parcelId = parcelId;
        this.trackingData = trackingData;
        this.shippingKey = shippingKey;
        this.type = type;
    }

    public String getDeliveryId() {
        return this.deliveryId;
    }

    public void setDeliveryId(String deliveryId) {
        this.deliveryId = deliveryId;
    }

    public String getParcelId() {
        return this.parcelId;
    }

    public void setParcelId(String parcelId) {
        this.parcelId = parcelId;
    }

    public TrackingData getTrackingData() {
        return this.trackingData;
    }

    public void setTrackingData(TrackingData trackingData) {
        this.trackingData = trackingData;
    }

    public String getShippingKey() {
        return this.shippingKey;
    }

    public void setShippingKey(String shippingKey) {
        this.shippingKey = shippingKey;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "ParcelTrackingDataUpdated{deliveryId='" + this.deliveryId + "', parcelId='" + this.parcelId + "', trackingData='" + this.trackingData + "', shippingKey='" + this.shippingKey + "', type='" + this.type + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParcelTrackingDataUpdated that = (ParcelTrackingDataUpdated)o;
        return Objects.equals(this.deliveryId, that.deliveryId) && Objects.equals(this.parcelId, that.parcelId) && Objects.equals(this.trackingData, that.trackingData) && Objects.equals(this.shippingKey, that.shippingKey) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.deliveryId, this.parcelId, this.trackingData, this.shippingKey, this.type);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String deliveryId;
        private String parcelId;
        private TrackingData trackingData;
        private String shippingKey;
        private String type;

        public ParcelTrackingDataUpdated build() {
            ParcelTrackingDataUpdated result = new ParcelTrackingDataUpdated();
            result.deliveryId = this.deliveryId;
            result.parcelId = this.parcelId;
            result.trackingData = this.trackingData;
            result.shippingKey = this.shippingKey;
            result.type = this.type;
            return result;
        }

        public Builder deliveryId(String deliveryId) {
            this.deliveryId = deliveryId;
            return this;
        }

        public Builder parcelId(String parcelId) {
            this.parcelId = parcelId;
            return this;
        }

        public Builder trackingData(TrackingData trackingData) {
            this.trackingData = trackingData;
            return this;
        }

        public Builder shippingKey(String shippingKey) {
            this.shippingKey = shippingKey;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }
}

