/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.graphql.api.types;

import com.commercetools.graphql.api.types.Payment;
import com.commercetools.graphql.api.types.Reference;
import java.util.List;
import java.util.Objects;

public class PaymentInfo {
    private List<Payment> payments;
    private List<Reference> paymentRefs;

    public PaymentInfo() {
    }

    public PaymentInfo(List<Payment> payments, List<Reference> paymentRefs) {
        this.payments = payments;
        this.paymentRefs = paymentRefs;
    }

    public List<Payment> getPayments() {
        return this.payments;
    }

    public void setPayments(List<Payment> payments) {
        this.payments = payments;
    }

    public List<Reference> getPaymentRefs() {
        return this.paymentRefs;
    }

    public void setPaymentRefs(List<Reference> paymentRefs) {
        this.paymentRefs = paymentRefs;
    }

    public String toString() {
        return "PaymentInfo{payments='" + this.payments + "', paymentRefs='" + this.paymentRefs + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInfo that = (PaymentInfo)o;
        return Objects.equals(this.payments, that.payments) && Objects.equals(this.paymentRefs, that.paymentRefs);
    }

    public int hashCode() {
        return Objects.hash(this.payments, this.paymentRefs);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<Payment> payments;
        private List<Reference> paymentRefs;

        public PaymentInfo build() {
            PaymentInfo result = new PaymentInfo();
            result.payments = this.payments;
            result.paymentRefs = this.paymentRefs;
            return result;
        }

        public Builder payments(List<Payment> payments) {
            this.payments = payments;
            return this;
        }

        public Builder paymentRefs(List<Reference> paymentRefs) {
            this.paymentRefs = paymentRefs;
            return this;
        }
    }
}

